/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyCentralizedThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.spring.orm.LastSessionRecorderHelperUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

public class CompanyThreadLocal {
    private static final Log _log = LogFactoryUtil.getLog(CompanyThreadLocal.class);
    private static final CentralizedThreadLocal<Long> _companyId;
    private static final CentralizedThreadLocal<Boolean> _initializingPortalInstance;
    private static final ThreadLocal<Boolean> _locked;
    private static final CentralizedThreadLocal<Boolean> _upgradingPortalInstance;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static User fetchGuestUser() {
        User guestUser;
        Long companyId;
        block29: {
            companyId = (Long)_companyId.get();
            if (companyId == 0L) {
                return null;
            }
            guestUser = null;
            if (!CompanyThreadLocal.isUpgradingPortalInstance()) {
                try {
                    guestUser = UserLocalServiceUtil.fetchGuestUser(companyId);
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block29;
                    _log.debug(exception);
                }
            }
        }
        if (guestUser != null) {
            return guestUser;
        }
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("select userId, languageId, timeZoneId from User_ where companyId = ? and type_ = ?");){
            preparedStatement.setLong(1, companyId);
            preparedStatement.setInt(2, 0);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) {
                    User user = null;
                    return user;
                }
                guestUser = UserLocalServiceUtil.createUser(resultSet.getLong("userId"));
                guestUser.setLanguageId(resultSet.getString("languageId"));
                guestUser.setTimeZoneId(resultSet.getString("timeZoneId"));
                return guestUser;
            }
        }
        catch (Exception exception) {
            if (!_log.isDebugEnabled()) return guestUser;
            _log.debug(exception);
        }
        return guestUser;
    }

    public static Long getCompanyId() {
        Long companyId = (Long)_companyId.get();
        if (_log.isDebugEnabled()) {
            _log.debug("Get company ID " + companyId);
        }
        return companyId;
    }

    public static long getNonsystemCompanyId() {
        long companyId = (Long)_companyId.get();
        if (companyId == 0L) {
            return PortalInstancePool.getDefaultCompanyId();
        }
        return companyId;
    }

    public static boolean isInitializingPortalInstance() {
        return (Boolean)_initializingPortalInstance.get();
    }

    public static boolean isLocked() {
        return _locked.get();
    }

    public static boolean isUpgradingPortalInstance() {
        return (Boolean)_upgradingPortalInstance.get();
    }

    public static SafeCloseable lock(long companyId) {
        long currentCompanyId = (Long)_companyId.get();
        if (companyId == currentCompanyId) {
            if (CompanyThreadLocal.isLocked()) {
                return () -> {};
            }
            _locked.set(true);
            return () -> _locked.set(false);
        }
        if (CompanyThreadLocal.isLocked()) {
            throw new UnsupportedOperationException(StringBundler.concat((Object[])new Object[]{"Company ID ", companyId, " and company ID ", currentCompanyId, " are different"}));
        }
        CompanyThreadLocal._syncLastDBPartitionSessionState();
        SafeCloseable safeCloseable = _companyId.setWithSafeCloseable((Object)companyId);
        _locked.set(true);
        return () -> {
            _locked.set(false);
            CompanyThreadLocal._syncLastDBPartitionSessionState();
            safeCloseable.close();
        };
    }

    public static void setCompanyId(Long companyId) {
        if (companyId.equals(_companyId.get())) {
            return;
        }
        if (CompanyThreadLocal.isLocked()) {
            throw new UnsupportedOperationException("CompanyThreadLocal modification is not allowed");
        }
        CompanyThreadLocal._syncLastDBPartitionSessionState();
        if (_log.isDebugEnabled()) {
            _log.debug("setCompanyId " + companyId);
        }
        if (companyId > 0L) {
            _companyId.set((Object)companyId);
        } else {
            _companyId.set((Object)0L);
        }
        for (CompanyCentralizedThreadLocal<?> companyCentralizedThreadLocal : CompanyCentralizedThreadLocal.getCompanyCentralizedThreadLocals()) {
            companyCentralizedThreadLocal.remove();
        }
        CTCollectionThreadLocal.removeCTCollectionId();
    }

    public static SafeCloseable setCompanyIdWithSafeCloseable(Long companyId) {
        return CompanyThreadLocal.setCompanyIdWithSafeCloseable(companyId, 0L);
    }

    public static SafeCloseable setCompanyIdWithSafeCloseable(Long companyId, Long ctCollectionId) {
        ArrayList<SafeCloseable> safeCloseables = new ArrayList<SafeCloseable>();
        if (!companyId.equals(_companyId.get())) {
            if (CompanyThreadLocal.isLocked()) {
                throw new UnsupportedOperationException("CompanyThreadLocal modification is not allowed");
            }
            CompanyThreadLocal._syncLastDBPartitionSessionState();
            if (_log.isDebugEnabled()) {
                _log.debug("setCompanyId " + companyId);
            }
            if (companyId > 0L) {
                safeCloseables.add(_companyId.setWithSafeCloseable((Object)companyId));
            } else {
                safeCloseables.add(_companyId.setWithSafeCloseable((Object)0L));
            }
            for (CompanyCentralizedThreadLocal<?> companyCentralizedThreadLocal : CompanyCentralizedThreadLocal.getCompanyCentralizedThreadLocals()) {
                safeCloseables.add(companyCentralizedThreadLocal.setWithSafeCloseable(null));
                companyCentralizedThreadLocal.remove();
            }
        }
        safeCloseables.add(CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable(ctCollectionId));
        return () -> {
            if (safeCloseables.size() > 1) {
                CompanyThreadLocal._syncLastDBPartitionSessionState();
            }
            for (SafeCloseable safeCloseable : safeCloseables) {
                safeCloseable.close();
            }
        };
    }

    public static SafeCloseable setInitializingCompanyIdWithSafeCloseable(long companyId) {
        if (companyId > 0L) {
            return _companyId.setWithSafeCloseable((Object)companyId);
        }
        return _companyId.setWithSafeCloseable((Object)0L);
    }

    public static SafeCloseable setInitializingPortalInstanceWithSafeCloseable(boolean initializingPortalInstance) {
        return _initializingPortalInstance.setWithSafeCloseable((Object)initializingPortalInstance);
    }

    public static SafeCloseable setUpgradingPortalInstanceWithSafeCloseable(boolean upgradingPortalInstance) {
        return _upgradingPortalInstance.setWithSafeCloseable((Object)upgradingPortalInstance);
    }

    private static void _syncLastDBPartitionSessionState() {
        if (DBPartition.isPartitionEnabled()) {
            LastSessionRecorderHelperUtil.syncLastSessionState(false);
        }
    }

    static {
        _initializingPortalInstance = new CentralizedThreadLocal(CompanyThreadLocal.class + "._initializingPortalInstance", () -> Boolean.FALSE);
        _locked = new CentralizedThreadLocal(CompanyThreadLocal.class + "._locked", () -> Boolean.FALSE);
        _upgradingPortalInstance = new CentralizedThreadLocal(CompanyThreadLocal.class + "._upgradingPortalInstance", () -> Boolean.FALSE);
        _companyId = new CentralizedThreadLocal(CompanyThreadLocal.class + "._companyId", () -> 0L);
    }
}

