/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.ScreenNameGenerator;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

public class DefaultScreenNameGenerator
implements ScreenNameGenerator {
    private static final String[] _ADMIN_RESERVED_SCREEN_NAMES = StringUtil.splitLines(PropsUtil.get("admin.reserved.screen.names"));
    private static final String _NONNUMERICAL_PREFIX = "user.";
    private static final boolean _USERS_SCREEN_NAME_ALLOW_NUMERIC = GetterUtil.getBoolean(PropsUtil.get("users.screen.name.allow.numeric"));

    @Override
    public String generate(long companyId, long userId, String emailAddress) throws Exception {
        String[] reservedScreenNames;
        Object screenName = null;
        if (Validator.isNotNull(emailAddress)) {
            screenName = StringUtil.extractFirst(emailAddress, '@');
            screenName = StringUtil.toLowerCase((String)screenName);
            for (char c : ((String)screenName).toCharArray()) {
                if (Validator.isChar(c) || Validator.isDigit(c) || c == '-' || c == '.') continue;
                screenName = StringUtil.replace((String)screenName, c, '.');
            }
            if (((String)screenName).equals("postfix")) {
                screenName = (String)screenName + "." + userId;
            }
        } else {
            screenName = String.valueOf(userId);
        }
        if (!_USERS_SCREEN_NAME_ALLOW_NUMERIC && Validator.isNumber((String)screenName)) {
            screenName = _NONNUMERICAL_PREFIX + (String)screenName;
        }
        for (String reservedScreenName : reservedScreenNames = PrefsPropsUtil.getStringArray(companyId, "admin.reserved.screen.names", "\n", _ADMIN_RESERVED_SCREEN_NAMES)) {
            if (!StringUtil.equalsIgnoreCase((String)screenName, reservedScreenName)) continue;
            return this.getUnusedScreenName(companyId, (String)screenName);
        }
        User user = UserLocalServiceUtil.fetchUserByScreenName(companyId, (String)screenName);
        if (user != null) {
            return this.getUnusedScreenName(companyId, (String)screenName);
        }
        Group friendlyURLGroup = GroupLocalServiceUtil.fetchFriendlyURLGroup(companyId, "/" + (String)screenName);
        if (friendlyURLGroup == null) {
            return screenName;
        }
        return this.getUnusedScreenName(companyId, (String)screenName);
    }

    protected String getUnusedScreenName(long companyId, String screenName) {
        int i = 1;
        Group friendlyURLGroup;
        String tempScreenName;
        User user;
        while ((user = UserLocalServiceUtil.fetchUserByScreenName(companyId, tempScreenName = screenName + "." + i)) != null || (friendlyURLGroup = GroupLocalServiceUtil.fetchFriendlyURLGroup(companyId, "/" + tempScreenName)) != null) {
            ++i;
        }
        return tempScreenName;
    }
}

