/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.permission.resource;

import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.WorkflowedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import java.util.Objects;
import java.util.function.ToLongFunction;

public class WorkflowedModelPermissionLogic<T extends GroupedModel>
implements ModelResourcePermissionLogic<T> {
    private final GroupLocalService _groupLocalService;
    private final ModelResourcePermission<T> _modelResourcePermission;
    private final ToLongFunction<T> _primKeyToLongFunction;

    public WorkflowedModelPermissionLogic(ModelResourcePermission<T> modelResourcePermission, GroupLocalService groupLocalService, ToLongFunction<T> primKeyToLongFunction) {
        this._modelResourcePermission = Objects.requireNonNull(modelResourcePermission);
        this._groupLocalService = groupLocalService;
        this._primKeyToLongFunction = Objects.requireNonNull(primKeyToLongFunction);
    }

    @Override
    public Boolean contains(PermissionChecker permissionChecker, String name, T model, String actionId) throws PortalException {
        WorkflowedModel workflowedModel = (WorkflowedModel)model;
        if (workflowedModel.isDraft() || workflowedModel.isScheduled()) {
            if (!actionId.equals("VIEW") || this._modelResourcePermission.contains(permissionChecker, model, "UPDATE")) {
                return null;
            }
            if (model.getGroupId() == 0L || !(model instanceof StagedModel)) {
                return false;
            }
            Group group = this._groupLocalService.getGroup(model.getGroupId());
            if (!group.isStaged() || group.isStagingGroup() || group.isStagedRemotely()) {
                return false;
            }
            StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(model.getModelClassName());
            StagedModel liveStagedModel = (StagedModel)model;
            Group stagingGroup = group.getStagingGroup();
            Object stagingStagedModel = stagedModelDataHandler.fetchStagedModelByUuidAndGroupId(liveStagedModel.getUuid(), stagingGroup.getGroupId());
            if (!actionId.equals("VIEW") || stagingStagedModel == null || this._modelResourcePermission.contains(permissionChecker, (GroupedModel)stagingStagedModel, "UPDATE")) {
                return null;
            }
            return false;
        }
        if (workflowedModel.isPending()) {
            return WorkflowPermissionUtil.hasPermission(permissionChecker, model.getGroupId(), name, this._primKeyToLongFunction.applyAsLong(model), actionId);
        }
        return null;
    }
}

