/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.OrgLabor;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class OrganizationServiceUtil {
    private static volatile OrganizationService _service;

    public static void addGroupOrganizations(long groupId, long[] organizationIds) throws PortalException {
        OrganizationServiceUtil.getService().addGroupOrganizations(groupId, organizationIds);
    }

    public static Organization addOrganization(String externalReferenceCode, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusListTypeId, String comments, boolean site, List<Address> addresses, List<EmailAddress> emailAddresses, List<OrgLabor> orgLabors, List<Phone> phones, List<Website> websites, ServiceContext serviceContext) throws PortalException {
        return OrganizationServiceUtil.getService().addOrganization(externalReferenceCode, parentOrganizationId, name, type, regionId, countryId, statusListTypeId, comments, site, addresses, emailAddresses, orgLabors, phones, websites, serviceContext);
    }

    public static Organization addOrganization(String externalReferenceCode, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusListTypeId, String comments, boolean site, ServiceContext serviceContext) throws PortalException {
        return OrganizationServiceUtil.getService().addOrganization(externalReferenceCode, parentOrganizationId, name, type, regionId, countryId, statusListTypeId, comments, site, serviceContext);
    }

    public static User addOrganizationUserByEmailAddress(String emailAddress, long organizationId, ServiceContext serviceContext) throws PortalException {
        return OrganizationServiceUtil.getService().addOrganizationUserByEmailAddress(emailAddress, organizationId, serviceContext);
    }

    public static Organization addOrUpdateOrganization(String externalReferenceCode, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusListTypeId, String comments, boolean hasLogo, byte[] logoBytes, boolean site, List<Address> addresses, List<EmailAddress> emailAddresses, List<OrgLabor> orgLabors, List<Phone> phones, List<Website> websites, ServiceContext serviceContext) throws PortalException {
        return OrganizationServiceUtil.getService().addOrUpdateOrganization(externalReferenceCode, parentOrganizationId, name, type, regionId, countryId, statusListTypeId, comments, hasLogo, logoBytes, site, addresses, emailAddresses, orgLabors, phones, websites, serviceContext);
    }

    public static void addPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) throws PortalException {
        OrganizationServiceUtil.getService().addPasswordPolicyOrganizations(passwordPolicyId, organizationIds);
    }

    public static void addUserOrganizationByEmailAddress(String emailAddress, long organizationId) throws PortalException {
        OrganizationServiceUtil.getService().addUserOrganizationByEmailAddress(emailAddress, organizationId);
    }

    public static void deleteLogo(long organizationId) throws PortalException {
        OrganizationServiceUtil.getService().deleteLogo(organizationId);
    }

    public static void deleteOrganization(long organizationId) throws PortalException {
        OrganizationServiceUtil.getService().deleteOrganization(organizationId);
    }

    public static void deleteUserOrganizationByEmailAddress(String emailAddress, long organizationId) throws PortalException {
        OrganizationServiceUtil.getService().deleteUserOrganizationByEmailAddress(emailAddress, organizationId);
    }

    public static Organization fetchOrganization(long organizationId) throws PortalException {
        return OrganizationServiceUtil.getService().fetchOrganization(organizationId);
    }

    public static Organization fetchOrganizationByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return OrganizationServiceUtil.getService().fetchOrganizationByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public static List<Organization> getGtOrganizations(long gtOrganizationId, long companyId, long parentOrganizationId, int size) {
        return OrganizationServiceUtil.getService().getGtOrganizations(gtOrganizationId, companyId, parentOrganizationId, size);
    }

    public static Organization getOrganization(long organizationId) throws PortalException {
        return OrganizationServiceUtil.getService().getOrganization(organizationId);
    }

    public static Organization getOrganizationByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return OrganizationServiceUtil.getService().getOrganizationByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public static long getOrganizationId(long companyId, String name) throws PortalException {
        return OrganizationServiceUtil.getService().getOrganizationId(companyId, name);
    }

    public static List<Organization> getOrganizations(long companyId, long parentOrganizationId) {
        return OrganizationServiceUtil.getService().getOrganizations(companyId, parentOrganizationId);
    }

    public static List<Organization> getOrganizations(long companyId, long parentOrganizationId, int start, int end) {
        return OrganizationServiceUtil.getService().getOrganizations(companyId, parentOrganizationId, start, end);
    }

    public static List<Organization> getOrganizations(long companyId, long parentOrganizationId, int start, int end, OrderByComparator<Organization> orderByComparator) {
        return OrganizationServiceUtil.getService().getOrganizations(companyId, parentOrganizationId, start, end, orderByComparator);
    }

    public static List<Organization> getOrganizations(long companyId, long parentOrganizationId, String name, int start, int end) {
        return OrganizationServiceUtil.getService().getOrganizations(companyId, parentOrganizationId, name, start, end);
    }

    public static List<Organization> getOrganizations(long companyId, long parentOrganizationId, String name, int start, int end, OrderByComparator<Organization> orderByComparator) {
        return OrganizationServiceUtil.getService().getOrganizations(companyId, parentOrganizationId, name, start, end, orderByComparator);
    }

    public static int getOrganizationsCount(long companyId, long parentOrganizationId) {
        return OrganizationServiceUtil.getService().getOrganizationsCount(companyId, parentOrganizationId);
    }

    public static int getOrganizationsCount(long companyId, long parentOrganizationId, String name) throws PortalException {
        return OrganizationServiceUtil.getService().getOrganizationsCount(companyId, parentOrganizationId, name);
    }

    public static String getOSGiServiceIdentifier() {
        return OrganizationServiceUtil.getService().getOSGiServiceIdentifier();
    }

    public static List<Organization> getUserOrganizations(long userId) throws PortalException {
        return OrganizationServiceUtil.getService().getUserOrganizations(userId);
    }

    public static void setGroupOrganizations(long groupId, long[] organizationIds) throws PortalException {
        OrganizationServiceUtil.getService().setGroupOrganizations(groupId, organizationIds);
    }

    public static void unsetGroupOrganizations(long groupId, long[] organizationIds) throws PortalException {
        OrganizationServiceUtil.getService().unsetGroupOrganizations(groupId, organizationIds);
    }

    public static void unsetPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) throws PortalException {
        OrganizationServiceUtil.getService().unsetPasswordPolicyOrganizations(passwordPolicyId, organizationIds);
    }

    public static Organization updateLogo(long organizationId, byte[] logoBytes) throws PortalException {
        return OrganizationServiceUtil.getService().updateLogo(organizationId, logoBytes);
    }

    public static Organization updateOrganization(String externalReferenceCode, long organizationId, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusListTypeId, String comments, boolean hasLogo, byte[] logoBytes, boolean site, List<Address> addresses, List<EmailAddress> emailAddresses, List<OrgLabor> orgLabors, List<Phone> phones, List<Website> websites, ServiceContext serviceContext) throws PortalException {
        return OrganizationServiceUtil.getService().updateOrganization(externalReferenceCode, organizationId, parentOrganizationId, name, type, regionId, countryId, statusListTypeId, comments, hasLogo, logoBytes, site, addresses, emailAddresses, orgLabors, phones, websites, serviceContext);
    }

    public static Organization updateOrganization(String externalReferenceCode, long organizationId, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusListTypeId, String comments, boolean site, ServiceContext serviceContext) throws PortalException {
        return OrganizationServiceUtil.getService().updateOrganization(externalReferenceCode, organizationId, parentOrganizationId, name, type, regionId, countryId, statusListTypeId, comments, site, serviceContext);
    }

    public static OrganizationService getService() {
        return _service;
    }

    public static void setService(OrganizationService service) {
        _service = service;
    }
}

