/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service;

import com.liferay.portal.kernel.security.auth.CompanyCentralizedThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.LinkedList;

public class ServiceContextThreadLocal {
    private static final ThreadLocal<LinkedList<ServiceContext>> _serviceContexts = new CompanyCentralizedThreadLocal<LinkedList>(ServiceContextThreadLocal.class + "._serviceContexts", LinkedList::new, serviceContexts -> {
        LinkedList<ServiceContext> cloneServiceContexts = new LinkedList<ServiceContext>();
        for (ServiceContext serviceContext : serviceContexts) {
            ServiceContext cloneServiceContext = null;
            if (serviceContext != null) {
                cloneServiceContext = (ServiceContext)serviceContext.clone();
            }
            cloneServiceContexts.add(cloneServiceContext);
        }
        return cloneServiceContexts;
    });

    public static ServiceContext getServiceContext() {
        LinkedList<ServiceContext> serviceContexts = _serviceContexts.get();
        return serviceContexts.peek();
    }

    public static ServiceContext popServiceContext() {
        LinkedList<ServiceContext> serviceContexts = _serviceContexts.get();
        if (serviceContexts.isEmpty()) {
            return null;
        }
        return serviceContexts.pop();
    }

    public static void pushServiceContext(ServiceContext serviceContext) {
        LinkedList<ServiceContext> serviceContexts = _serviceContexts.get();
        serviceContexts.push(serviceContext);
    }

    public static void remove() {
        LinkedList<ServiceContext> serviceContexts = _serviceContexts.get();
        if (serviceContexts != null) {
            serviceContexts.clear();
        }
    }
}

