/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;

public class OrganizationPermissionUtil {
    public static void check(PermissionChecker permissionChecker, long organizationId, String actionId) throws PortalException {
        if (!OrganizationPermissionUtil.contains(permissionChecker, organizationId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Organization.class.getName(), organizationId, actionId);
        }
    }

    public static void check(PermissionChecker permissionChecker, Organization organization, String actionId) throws PortalException {
        if (!OrganizationPermissionUtil.contains(permissionChecker, organization, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Organization.class.getName(), organization.getOrganizationId(), actionId);
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long organizationId, String actionId) throws PortalException {
        if (organizationId > 0L) {
            return OrganizationPermissionUtil.contains(permissionChecker, OrganizationLocalServiceUtil.getOrganization(organizationId), actionId);
        }
        return false;
    }

    public static boolean contains(PermissionChecker permissionChecker, long[] organizationIds, String actionId) throws PortalException {
        if (ArrayUtil.isEmpty(organizationIds)) {
            return false;
        }
        for (long organizationId : organizationIds) {
            if (OrganizationPermissionUtil.contains(permissionChecker, organizationId, actionId)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(PermissionChecker permissionChecker, Organization organization, String actionId) throws PortalException {
        return OrganizationPermissionUtil._contains(permissionChecker, organization.getGroupId(), organization, actionId);
    }

    private static boolean _contains(PermissionChecker permissionChecker, long groupId, Organization organization, String actionId) throws PortalException {
        while (organization != null && organization.getOrganizationId() != 0L) {
            if (actionId.equals("ADD_ORGANIZATION") && (permissionChecker.hasPermission(groupId, Organization.class.getName(), organization.getOrganizationId(), "MANAGE_SUBORGANIZATIONS") || permissionChecker.hasPermission(groupId, Organization.class.getName(), organization.getOrganizationId(), "UPDATE_SUBORGANIZATIONS") || PortalPermissionUtil.contains(permissionChecker, "ADD_ORGANIZATION"))) {
                return true;
            }
            if (permissionChecker.hasPermission(groupId, Organization.class.getName(), organization.getOrganizationId(), actionId)) {
                return true;
            }
            organization = organization.getParentOrganization();
        }
        return false;
    }
}

