/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service.permission;

import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.portlet.ControlPanelEntry;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletMode;

public class PortletPermissionUtil {
    private static final boolean _CHECK_STAGING_PERMISSION_DEFAULT = true;
    private static final boolean _STRICT_DEFAULT = false;
    private static final Log _log = LogFactoryUtil.getLog(PortletPermissionUtil.class);

    public static void check(PermissionChecker permissionChecker, Layout layout, String portletId, String actionId) throws PortalException {
        if (!PortletPermissionUtil.contains(permissionChecker, 0L, layout, portletId, actionId, false)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Portlet.class.getName(), portletId, actionId);
        }
    }

    public static void check(PermissionChecker permissionChecker, Layout layout, String portletId, String actionId, boolean strict) throws PortalException {
        if (!PortletPermissionUtil.contains(permissionChecker, 0L, layout, portletId, actionId, strict)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Portlet.class.getName(), portletId, actionId);
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, Layout layout, String portletId, String actionId) throws PortalException {
        if (!PortletPermissionUtil.contains(permissionChecker, groupId, layout, portletId, actionId, false)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Portlet.class.getName(), portletId, actionId);
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, Layout layout, String portletId, String actionId, boolean strict) throws PortalException {
        PortletPermissionUtil.check(permissionChecker, groupId, layout, portletId, actionId, strict, true);
    }

    public static void check(PermissionChecker permissionChecker, long groupId, Layout layout, String portletId, String actionId, boolean strict, boolean checkStagingPermission) throws PortalException {
        if (!PortletPermissionUtil.contains(permissionChecker, groupId, layout, portletId, actionId, strict, checkStagingPermission)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Portlet.class.getName(), portletId, actionId);
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, long plid, String portletId, String actionId) throws PortalException {
        PortletPermissionUtil.check(permissionChecker, groupId, plid, portletId, actionId, false);
    }

    public static void check(PermissionChecker permissionChecker, long groupId, long plid, String portletId, String actionId, boolean strict) throws PortalException {
        if (!PortletPermissionUtil.contains(permissionChecker, groupId, plid, portletId, actionId, strict)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Portlet.class.getName(), portletId, actionId);
        }
    }

    public static void check(PermissionChecker permissionChecker, long plid, String portletId, String actionId) throws PortalException {
        PortletPermissionUtil.check(permissionChecker, plid, portletId, actionId, false);
    }

    public static void check(PermissionChecker permissionChecker, long plid, String portletId, String actionId, boolean strict) throws PortalException {
        if (!PortletPermissionUtil.contains(permissionChecker, plid, portletId, actionId, strict)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Portlet.class.getName(), portletId, actionId);
        }
    }

    public static void check(PermissionChecker permissionChecker, String portletId, String actionId) throws PortalException {
        if (!PortletPermissionUtil.contains(permissionChecker, portletId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Portlet.class.getName(), portletId, actionId);
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, Layout layout, Portlet portlet, String actionId) throws PortalException {
        return PortletPermissionUtil.contains(permissionChecker, layout, portlet, actionId, false);
    }

    public static boolean contains(PermissionChecker permissionChecker, Layout layout, Portlet portlet, String actionId, boolean strict) throws PortalException {
        return PortletPermissionUtil.contains(permissionChecker, 0L, layout, portlet, actionId, strict);
    }

    public static boolean contains(PermissionChecker permissionChecker, Layout layout, String portletId, String actionId) throws PortalException {
        return PortletPermissionUtil.contains(permissionChecker, layout, portletId, actionId, false);
    }

    public static boolean contains(PermissionChecker permissionChecker, Layout layout, String portletId, String actionId, boolean strict) throws PortalException {
        return PortletPermissionUtil.contains(permissionChecker, 0L, layout, portletId, actionId, strict);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, Layout layout, Portlet portlet, String actionId) throws PortalException {
        return PortletPermissionUtil.contains(permissionChecker, groupId, layout, portlet, actionId, false);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, Layout layout, Portlet portlet, String actionId, boolean strict) throws PortalException {
        if (portlet.isUndeployedPortlet()) {
            return false;
        }
        return PortletPermissionUtil.contains(permissionChecker, groupId, layout, portlet, actionId, strict, true);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, Layout layout, Portlet portlet, String actionId, boolean strict, boolean checkStagingPermission) throws PortalException {
        CacheKey cacheKey;
        Map<Object, Object> permissionChecksMap;
        Boolean contains;
        long plid = -1L;
        long layoutMvccVersion = -1L;
        if (layout != null) {
            plid = layout.getPlid();
            layoutMvccVersion = layout.getMvccVersion();
        }
        if ((contains = (Boolean)(permissionChecksMap = permissionChecker.getPermissionChecksMap()).get(cacheKey = new CacheKey(groupId, plid, layoutMvccVersion, portlet.getPortletId(), portlet.getMvccVersion(), actionId, strict, checkStagingPermission))) == null) {
            contains = PortletPermissionUtil._contains(permissionChecker, groupId, layout, portlet, actionId, strict, checkStagingPermission);
            permissionChecksMap.put(cacheKey, contains);
        }
        return contains;
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, Layout layout, String portletId, String actionId) throws PortalException {
        return PortletPermissionUtil.contains(permissionChecker, groupId, layout, portletId, actionId, false);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, Layout layout, String portletId, String actionId, boolean strict) throws PortalException {
        return PortletPermissionUtil.contains(permissionChecker, groupId, layout, portletId, actionId, strict, true);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, Layout layout, String portletId, String actionId, boolean strict, boolean checkStagingPermission) throws PortalException {
        Portlet portlet = PortletLocalServiceUtil.getPortletById(permissionChecker.getCompanyId(), portletId);
        if (portlet == null || portlet.isUndeployedPortlet()) {
            return false;
        }
        return PortletPermissionUtil.contains(permissionChecker, groupId, layout, portlet, actionId, strict, checkStagingPermission);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long plid, String portletId, String actionId, boolean strict) throws PortalException {
        return PortletPermissionUtil.contains(permissionChecker, groupId, LayoutLocalServiceUtil.fetchLayout(plid), portletId, actionId, strict);
    }

    public static boolean contains(PermissionChecker permissionChecker, long plid, Portlet portlet, String actionId) throws PortalException {
        return PortletPermissionUtil.contains(permissionChecker, LayoutLocalServiceUtil.fetchLayout(plid), portlet, actionId, false);
    }

    public static boolean contains(PermissionChecker permissionChecker, long plid, Portlet portlet, String actionId, boolean strict) throws PortalException {
        return PortletPermissionUtil.contains(permissionChecker, 0L, LayoutLocalServiceUtil.fetchLayout(plid), portlet, actionId, strict);
    }

    public static boolean contains(PermissionChecker permissionChecker, long plid, String portletId, String actionId) throws PortalException {
        return PortletPermissionUtil.contains(permissionChecker, LayoutLocalServiceUtil.fetchLayout(plid), portletId, actionId, false);
    }

    public static boolean contains(PermissionChecker permissionChecker, long plid, String portletId, String actionId, boolean strict) throws PortalException {
        return PortletPermissionUtil.contains(permissionChecker, 0L, LayoutLocalServiceUtil.fetchLayout(plid), portletId, actionId, strict);
    }

    public static boolean contains(PermissionChecker permissionChecker, String portletId, String actionId) throws PortalException {
        return PortletPermissionUtil.contains(permissionChecker, 0L, portletId, actionId);
    }

    public static String getPrimaryKey(long plid, String portletId) {
        return StringBundler.concat((Object[])new Object[]{plid, "_LAYOUT_", portletId});
    }

    public static boolean hasAccessPermission(PermissionChecker permissionChecker, long scopeGroupId, Layout layout, Portlet portlet, PortletMode portletMode) throws PortalException {
        boolean access;
        String category;
        if (layout != null && layout.isTypeControlPanel() && StringUtil.startsWith(category = portlet.getControlPanelEntryCategory(), "site_administration.")) {
            layout = null;
        }
        if ((access = PortletPermissionUtil.contains(permissionChecker, scopeGroupId, layout, portlet, "VIEW")) && portletMode.equals((Object)PortletMode.EDIT)) {
            access = PortletPermissionUtil.contains(permissionChecker, scopeGroupId, layout, portlet, "PREFERENCES");
        }
        return access;
    }

    public static boolean hasConfigurationPermission(PermissionChecker permissionChecker, long groupId, Layout layout, String actionId) throws PortalException {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        for (Portlet portlet : layoutTypePortlet.getAllPortlets(false)) {
            if (!PortletPermissionUtil.contains(permissionChecker, groupId, layout, portlet.getPortletId(), actionId) && !PortletPermissionUtil.contains(permissionChecker, groupId, null, portlet.getRootPortletId(), actionId)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasControlPanelAccessPermission(PermissionChecker permissionChecker, long scopeGroupId, Collection<Portlet> portlets) throws PortalException {
        for (Portlet portlet : portlets) {
            if (!PortletPermissionUtil.hasControlPanelAccessPermission(permissionChecker, scopeGroupId, portlet)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasControlPanelAccessPermission(PermissionChecker permissionChecker, long scopeGroupId, Portlet portlet) throws PortalException {
        if (portlet == null) {
            return false;
        }
        Group group = GroupLocalServiceUtil.getGroup(scopeGroupId);
        ControlPanelEntry controlPanelEntry = portlet.getControlPanelEntryInstance();
        try {
            return controlPanelEntry.hasAccessPermission(permissionChecker, group, portlet);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn("Cannot process control panel access permission", exception);
            }
            return false;
        }
    }

    public static boolean hasControlPanelAccessPermission(PermissionChecker permissionChecker, long scopeGroupId, String portletId) throws PortalException {
        Portlet portlet = PortletLocalServiceUtil.getPortletById(portletId);
        return PortletPermissionUtil.hasControlPanelAccessPermission(permissionChecker, scopeGroupId, portlet);
    }

    public static boolean hasLayoutManagerPermission(String portletId, String actionId) {
        try {
            portletId = PortletIdCodec.decodePortletName(portletId);
            List<String> layoutManagerActions = ResourceActionsUtil.getPortletResourceLayoutManagerActions(portletId);
            return layoutManagerActions.contains(actionId);
        }
        catch (Exception exception) {
            _log.error(exception);
            return false;
        }
    }

    private static boolean _contains(PermissionChecker permissionChecker, long groupId, Layout layout, Portlet portlet, String actionId, boolean strict, boolean checkStagingPermission) throws PortalException {
        Boolean hasPermission;
        String portletId = portlet.getPortletId();
        if (layout == null) {
            return permissionChecker.hasPermission(groupId, portletId, portletId, actionId);
        }
        Group group = null;
        if (groupId > 0L) {
            group = GroupLocalServiceUtil.fetchGroup(groupId);
        }
        if (group == null) {
            group = layout.getGroup();
            groupId = layout.getGroupId();
        }
        if ((group.isControlPanel() || layout.isTypeControlPanel()) && actionId.equals("VIEW")) {
            return true;
        }
        if (layout instanceof VirtualLayout) {
            if (layout.isCustomizable() && !actionId.equals("VIEW")) {
                if (actionId.equals("ADD_TO_PAGE")) {
                    return PortletPermissionUtil._hasAddToPagePermission(permissionChecker, layout, portletId);
                }
                return PortletPermissionUtil._hasCustomizePermission(permissionChecker, layout, portlet, actionId);
            }
            VirtualLayout virtualLayout = (VirtualLayout)layout;
            layout = virtualLayout.getSourceLayout();
        }
        if (!group.isLayoutSetPrototype() && actionId.equals("CONFIGURATION") && (layout instanceof VirtualLayout || !layout.isLayoutUpdateable())) {
            return false;
        }
        String rootPortletId = PortletIdCodec.decodePortletName(portletId);
        if (checkStagingPermission && (hasPermission = StagingPermissionUtil.hasPermission(permissionChecker, group, rootPortletId, groupId, rootPortletId, actionId)) != null) {
            return hasPermission;
        }
        String resourcePermissionPrimKey = PortletPermissionUtil.getPrimaryKey(layout.getPlid(), portletId);
        if (strict) {
            return permissionChecker.hasPermission(groupId, rootPortletId, resourcePermissionPrimKey, actionId);
        }
        if (PortletPermissionUtil._hasConfigurePermission(permissionChecker, layout, portlet, actionId) || PortletPermissionUtil._hasCustomizePermission(permissionChecker, layout, portlet, actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(group, rootPortletId, resourcePermissionPrimKey, actionId);
    }

    private static boolean _hasAddToPagePermission(PermissionChecker permissionChecker, Layout layout, String portletId) throws PortalException {
        if (LayoutPermissionUtil.contains(permissionChecker, layout, "CUSTOMIZE")) {
            return PortletPermissionUtil.contains(permissionChecker, portletId, "ADD_TO_PAGE");
        }
        return false;
    }

    private static boolean _hasConfigurePermission(PermissionChecker permissionChecker, Layout layout, Portlet portlet, String actionId) throws PortalException {
        if (!(actionId.equals("CONFIGURATION") || actionId.equals("PREFERENCES") || actionId.equals("GUEST_PREFERENCES"))) {
            return false;
        }
        if (portlet.isPreferencesUniquePerLayout() && (layout.isTypeEmbedded() || layout.isTypePanel() || layout.isTypePortlet())) {
            return LayoutPermissionUtil.contains(permissionChecker, layout, "CONFIGURE_PORTLETS");
        }
        return GroupPermissionUtil.contains(permissionChecker, layout.getGroupId(), "CONFIGURE_PORTLETS");
    }

    private static boolean _hasCustomizePermission(PermissionChecker permissionChecker, Layout layout, Portlet portlet, String actionId) throws PortalException {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        if (layoutTypePortlet.isCustomizedView() && layoutTypePortlet.isPortletCustomizable(portlet.getPortletId()) && LayoutPermissionUtil.contains(permissionChecker, layout, "CUSTOMIZE")) {
            if (actionId.equals("VIEW")) {
                return true;
            }
            if (actionId.equals("CONFIGURATION") && (portlet.isInstanceable() || portlet.isPreferencesUniquePerLayout())) {
                return true;
            }
        }
        return false;
    }

    private static class CacheKey {
        private final String _actionId;
        private final boolean _checkStagingPermission;
        private final long _groupId;
        private final long _layoutMvccVersion;
        private final long _plid;
        private final String _portletId;
        private final long _portletMvccVersion;
        private final boolean _strict;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            return this._groupId == cacheKey._groupId && this._plid == cacheKey._plid && this._layoutMvccVersion == cacheKey._layoutMvccVersion && Objects.equals(this._portletId, cacheKey._portletId) && this._portletMvccVersion == cacheKey._portletMvccVersion && Objects.equals(this._actionId, cacheKey._actionId) && this._strict == cacheKey._strict && this._checkStagingPermission == cacheKey._checkStagingPermission;
        }

        public int hashCode() {
            int hash = HashUtil.hash((int)0, (long)this._groupId);
            hash = HashUtil.hash((int)hash, (long)this._plid);
            hash = HashUtil.hash((int)hash, (long)this._layoutMvccVersion);
            hash = HashUtil.hash((int)hash, (Object)this._portletId);
            hash = HashUtil.hash((int)hash, (long)this._portletMvccVersion);
            hash = HashUtil.hash((int)hash, (Object)this._actionId);
            hash = HashUtil.hash((int)hash, (boolean)this._strict);
            return HashUtil.hash((int)hash, (boolean)this._checkStagingPermission);
        }

        private CacheKey(long groupId, long plid, long layoutMvccVersion, String portletId, long portletMvccVersion, String actionId, boolean strict, boolean checkStagingPermission) {
            this._groupId = groupId;
            this._plid = plid;
            this._layoutMvccVersion = layoutMvccVersion;
            this._portletId = portletId;
            this._portletMvccVersion = portletMvccVersion;
            this._actionId = actionId;
            this._strict = strict;
            this._checkStagingPermission = checkStagingPermission;
        }
    }
}

