/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.servlet.LiferayFilter;
import com.liferay.portal.kernel.servlet.LiferayFilterTracker;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilterHelper;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseFilter
implements LiferayFilter {
    private static final String _DEPTHER = "DEPTHER";
    private FilterConfig _filterConfig;
    private boolean _filterEnabled = true;

    public void destroy() {
        LiferayFilterTracker.removeLiferayFilter(this);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            this.processFilter((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
        }
        catch (IOException ioException) {
            throw ioException;
        }
        catch (ServletException servletException) {
            throw servletException;
        }
        catch (Exception exception) {
            Log log = this.getLog();
            log.error(exception, exception);
        }
    }

    public FilterConfig getFilterConfig() {
        return this._filterConfig;
    }

    public void init(FilterConfig filterConfig) {
        this._filterConfig = filterConfig;
        LiferayFilterTracker.addLiferayFilter(this);
    }

    @Override
    public boolean isFilterEnabled() {
        return this._filterEnabled;
    }

    @Override
    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this._filterEnabled;
    }

    @Override
    public void setFilterEnabled(boolean filterEnabled) {
        ServletContext servletContext;
        InvokerFilterHelper invokerFilterHelper;
        if (filterEnabled != this._filterEnabled && (invokerFilterHelper = (InvokerFilterHelper)(servletContext = this._filterConfig.getServletContext()).getAttribute(InvokerFilterHelper.class.getName())) != null) {
            invokerFilterHelper.clearFilterChainsCache();
        }
        this._filterEnabled = filterEnabled;
    }

    protected abstract Log getLog();

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        Class<?> clazz = this.getClass();
        this.processFilter(clazz.getName(), httpServletRequest, httpServletResponse, filterChain);
    }

    protected void processFilter(String logName, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        long startTime = 0L;
        String threadName = null;
        Object depther = null;
        String path = null;
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Thread currentThread = Thread.currentThread();
            threadName = currentThread.getName();
            depther = (String)httpServletRequest.getAttribute(_DEPTHER);
            depther = depther == null ? "" : (String)depther + "=";
            httpServletRequest.setAttribute(_DEPTHER, depther);
            path = httpServletRequest.getRequestURI();
            log.debug(StringBundler.concat((String[])new String[]{"[", threadName, "]", depther, "> ", logName, " ", path}));
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        if (!log.isDebugEnabled()) {
            return;
        }
        long endTime = System.currentTimeMillis();
        depther = (String)httpServletRequest.getAttribute(_DEPTHER);
        if (depther == null) {
            return;
        }
        log.debug(StringBundler.concat((Object[])new Object[]{"[", threadName, "]", depther, "< ", logName, " ", path, " ", endTime - startTime, " ms"}));
        if (((String)depther).length() > 0) {
            depther = ((String)depther).substring(1);
        }
        httpServletRequest.setAttribute(_DEPTHER, depther);
    }
}

