/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.JasperVersionDetector;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public class DirectServletRegistryUtil {
    private static final boolean _DIRECT_SERVLET_CONTEXT_RELOAD = GetterUtil.getBoolean(PropsUtil.get("direct.servlet.context.reload"));
    private static final Log _log = LogFactoryUtil.getLog(DirectServletRegistryUtil.class);
    private static final Map<String, Long> _dependantTimestamps = new ConcurrentHashMap<String, Long>();
    private static boolean _reloadDependants = true;
    private static final Map<String, ServletInfo> _servletInfos = new ConcurrentHashMap<String, ServletInfo>();

    public static void clearServlets() {
        _servletInfos.clear();
    }

    public static Servlet getServlet(String path) {
        ServletInfo servletInfo = _servletInfos.get(path);
        if (servletInfo == null) {
            return null;
        }
        Servlet servlet = servletInfo.getServlet();
        if (_DIRECT_SERVLET_CONTEXT_RELOAD) {
            long lastModified = DirectServletRegistryUtil._getFileLastModified(path, servlet);
            if (lastModified == 0L || lastModified != servletInfo.getLastModified()) {
                _servletInfos.remove(path);
                servlet = null;
                if (_log.isDebugEnabled()) {
                    _log.debug("Reload " + path);
                }
            } else {
                servlet = DirectServletRegistryUtil._reloadDependants(path, servlet);
            }
        }
        return servlet;
    }

    public static void putServlet(String path, Servlet servlet) {
        if (path.startsWith(PathModulePrefixHolder._PATH_MODULE_PREFIX) || _servletInfos.containsKey(path)) {
            return;
        }
        long lastModified = 1L;
        if (_DIRECT_SERVLET_CONTEXT_RELOAD) {
            lastModified = DirectServletRegistryUtil._getFileLastModified(path, servlet);
        }
        if (lastModified > 0L) {
            ServletInfo servletInfo = new ServletInfo();
            servletInfo.setLastModified(lastModified);
            servletInfo.setServlet(servlet);
            _servletInfos.put(path, servletInfo);
        }
    }

    private static File _getFile(String path, Servlet servlet) {
        ServletConfig servletConfig = servlet.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        String contextPath = servletContext.getContextPath();
        if (!Validator.isBlank(contextPath) && path.startsWith(contextPath)) {
            path = path.substring(contextPath.length());
        }
        return new File(servletContext.getRealPath(""), path);
    }

    private static long _getFileLastModified(String path, Servlet servlet) {
        File file = DirectServletRegistryUtil._getFile(path, servlet);
        if (file.exists()) {
            return file.lastModified();
        }
        return -1L;
    }

    private static Servlet _reloadDependants(String path, Servlet servlet) {
        if (!_reloadDependants) {
            return servlet;
        }
        try {
            Method method = ReflectionUtil.getDeclaredMethod(servlet.getClass(), (String)"getDependants", (Class[])new Class[0]);
            Collection<Object> dependants = null;
            if (JasperVersionDetector.hasJspServletDependantsMap()) {
                Map dependantsMap = (Map)method.invoke((Object)servlet, new Object[0]);
                if (dependantsMap != null) {
                    dependants = dependantsMap.keySet();
                }
            } else {
                dependants = (List)method.invoke((Object)servlet, new Object[0]);
            }
            if (dependants == null) {
                return servlet;
            }
            boolean reloadServlet = false;
            for (String string : dependants) {
                long lastModified = DirectServletRegistryUtil._getFileLastModified(string, servlet);
                Long previousLastModified = _dependantTimestamps.get(string);
                if (previousLastModified == null) {
                    _dependantTimestamps.put(string, lastModified);
                    previousLastModified = lastModified;
                }
                if (lastModified != 0L && lastModified == previousLastModified) continue;
                reloadServlet = true;
                _dependantTimestamps.put(string, lastModified);
                if (!_log.isDebugEnabled()) continue;
                _log.debug("Reload dependant " + string);
            }
            if (reloadServlet) {
                _servletInfos.remove(path);
                File file = DirectServletRegistryUtil._getFile(path, servlet);
                file.setLastModified(System.currentTimeMillis());
                servlet = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (_log.isWarnEnabled()) {
                _log.warn("Reloading of dependant JSP is disabled because your servlet container is not a variant of Jasper", noSuchMethodException);
            }
            _reloadDependants = false;
        }
        catch (Exception exception) {
            _log.error(exception);
        }
        return servlet;
    }

    private static class ServletInfo {
        private long _lastModified;
        private Servlet _servlet;

        private ServletInfo() {
        }

        public long getLastModified() {
            return this._lastModified;
        }

        public Servlet getServlet() {
            return this._servlet;
        }

        public void setLastModified(long lastModified) {
            this._lastModified = lastModified;
        }

        public void setServlet(Servlet servlet) {
            this._servlet = servlet;
        }
    }

    private static class PathModulePrefixHolder {
        private static final String _PATH_MODULE_PREFIX = StringBundler.concat((String[])new String[]{PortalUtil.getPathContext(), "/o", "/"});

        private PathModulePrefixHolder() {
        }
    }
}

