/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PluginContextLifecycleThreadLocal;
import com.liferay.portal.kernel.servlet.ServletContextClassLoaderPool;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class PluginContextListener
implements ServletContextAttributeListener,
ServletContextListener {
    public static final String PLUGIN_CLASS_LOADER = "PLUGIN_CLASS_LOADER";
    protected ClassLoader pluginClassLoader;
    protected ServletContext servletContext;
    private static final Log _log = LogFactoryUtil.getLog(PluginContextListener.class);
    private boolean _addedPluginClassLoader;
    private boolean _classLoaderRegistered;

    public void attributeAdded(ServletContextAttributeEvent servletContextAttributeEvent) {
        if (servletContextAttributeEvent.getServletContext() != this.servletContext) {
            return;
        }
        String name = servletContextAttributeEvent.getName();
        if (this._addedPluginClassLoader && name.equals(PLUGIN_CLASS_LOADER) && servletContextAttributeEvent.getValue() != this.pluginClassLoader) {
            if (_log.isWarnEnabled()) {
                _log.warn("Preventing the addition of another plugin class loader");
            }
            this.servletContext.setAttribute(PLUGIN_CLASS_LOADER, (Object)this.pluginClassLoader);
        } else if (!this._addedPluginClassLoader && name.equals(PLUGIN_CLASS_LOADER)) {
            this._addedPluginClassLoader = true;
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent servletContextAttributeEvent) {
        if (servletContextAttributeEvent.getServletContext() != this.servletContext) {
            return;
        }
        String name = servletContextAttributeEvent.getName();
        if (this._addedPluginClassLoader && name.equals(PLUGIN_CLASS_LOADER)) {
            if (_log.isWarnEnabled()) {
                _log.warn("Preventing the removal of the plugin class loader");
            }
            this.servletContext.setAttribute(PLUGIN_CLASS_LOADER, (Object)this.pluginClassLoader);
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent servletContextAttributeEvent) {
        if (servletContextAttributeEvent.getServletContext() != this.servletContext) {
            return;
        }
        String name = servletContextAttributeEvent.getName();
        if (this._addedPluginClassLoader && name.equals(PLUGIN_CLASS_LOADER)) {
            if (_log.isWarnEnabled()) {
                _log.warn("Preventing the replacement of the plugin class loader");
            }
            this.servletContext.removeAttribute(PLUGIN_CLASS_LOADER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        PluginContextLifecycleThreadLocal.setDestroying(true);
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)this.pluginClassLoader);){
            this.fireUndeployEvent();
        }
        finally {
            PluginContextLifecycleThreadLocal.setDestroying(false);
        }
        if (this._classLoaderRegistered) {
            ServletContextClassLoaderPool.unregister(this.servletContext.getServletContextName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.servletContext = servletContextEvent.getServletContext();
        Thread currentThread = Thread.currentThread();
        this.pluginClassLoader = currentThread.getContextClassLoader();
        String servletContextName = this.servletContext.getServletContextName();
        if (ServletContextClassLoaderPool.getClassLoader(servletContextName) == null) {
            ServletContextClassLoaderPool.register(servletContextName, this.pluginClassLoader);
            this._classLoaderRegistered = true;
        }
        this.servletContext.setAttribute(PLUGIN_CLASS_LOADER, (Object)this.pluginClassLoader);
        ServletContextPool.put(servletContextName, this.servletContext);
        PluginContextLifecycleThreadLocal.setInitializing(true);
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)this.pluginClassLoader);){
            this.fireDeployEvent();
        }
        finally {
            PluginContextLifecycleThreadLocal.setInitializing(false);
        }
    }

    protected void fireDeployEvent() {
        HotDeployUtil.fireDeployEvent(new HotDeployEvent(this.servletContext, this.pluginClassLoader));
    }

    protected void fireUndeployEvent() {
        HotDeployUtil.fireUndeployEvent(new HotDeployEvent(this.servletContext, this.pluginClassLoader));
    }
}

