/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortalClassLoaderServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(PortalClassLoaderServlet.class);
    private volatile HttpServlet _servlet;
    private ServletConfig _servletConfig;

    public void destroy() {
        if (this._servlet != null) {
            try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)PortalClassLoaderUtil.getClassLoader());){
                this._servlet.destroy();
            }
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._servletConfig = servletConfig;
        ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)portalClassLoader);){
            String servletClass = this._servletConfig.getInitParameter("servlet-class");
            this._servlet = (HttpServlet)InstanceFactory.newInstance(portalClassLoader, servletClass);
            this._servlet.init(this._servletConfig);
        }
        catch (Exception exception) {
            _log.error(exception);
        }
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)PortalClassLoaderUtil.getClassLoader());){
            this._servlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }
}

