/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.servlet.SessionMaps;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SessionErrors {
    private static final String _CLASS_NAME = SessionErrors.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(SessionErrors.class);
    private static final SessionMaps _sessionMaps = new SessionMaps(HashMap::new);

    public static void add(HttpServletRequest httpServletRequest, Class<?> clazz) {
        SessionErrors.add(SessionErrors._getPortalHttpSession(httpServletRequest), clazz.getName());
    }

    public static void add(HttpServletRequest httpServletRequest, Class<?> clazz, Object value) {
        SessionErrors.add(SessionErrors._getPortalHttpSession(httpServletRequest), clazz.getName(), value);
    }

    public static void add(HttpServletRequest httpServletRequest, String key) {
        SessionErrors.add(SessionErrors._getPortalHttpSession(httpServletRequest), key);
    }

    public static void add(HttpServletRequest httpServletRequest, String key, Object value) {
        SessionErrors.add(SessionErrors._getPortalHttpSession(httpServletRequest), key, value);
    }

    public static void add(HttpSession httpSession, Class<?> clazz) {
        SessionErrors.add(httpSession, clazz.getName());
    }

    public static void add(HttpSession httpSession, Class<?> clazz, Object value) {
        SessionErrors.add(httpSession, clazz.getName(), value);
    }

    public static void add(HttpSession httpSession, String key) {
        if (_log.isDebugEnabled()) {
            _log.debug("Adding key " + key);
        }
        _sessionMaps.add(httpSession, _CLASS_NAME, key, key);
    }

    public static void add(HttpSession httpSession, String key, Object value) {
        if (_log.isDebugEnabled()) {
            Exception exception = null;
            if (value instanceof Exception) {
                exception = (Exception)value;
            }
            _log.debug(StringBundler.concat((Object[])new Object[]{"Adding key ", key, " with value ", value}), exception);
        }
        _sessionMaps.add(httpSession, _CLASS_NAME, key, value);
    }

    public static void add(PortletRequest portletRequest, Class<?> clazz) {
        SessionErrors.add(portletRequest, clazz.getName());
    }

    public static void add(PortletRequest portletRequest, Class<?> clazz, Object value) {
        SessionErrors.add(portletRequest, clazz.getName(), value);
    }

    public static void add(PortletRequest portletRequest, String key) {
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat((String[])new String[]{"Adding key ", key, " to portlet ", portletRequest.getWindowID()}));
        }
        _sessionMaps.add(SessionErrors._getPortalHttpSession(portletRequest), SessionErrors._getKey(portletRequest), key, key);
    }

    public static void add(PortletRequest portletRequest, String key, Object value) {
        if (_log.isDebugEnabled()) {
            Exception exception = null;
            if (value instanceof Exception) {
                exception = (Exception)value;
            }
            _log.debug(StringBundler.concat((Object[])new Object[]{"Adding key ", key, " to portlet ", portletRequest.getWindowID(), " with value ", value}), exception);
        }
        _sessionMaps.add(SessionErrors._getPortalHttpSession(portletRequest), SessionErrors._getKey(portletRequest), key, value);
    }

    public static void clear(HttpServletRequest httpServletRequest) {
        SessionErrors.clear(SessionErrors._getPortalHttpSession(httpServletRequest));
    }

    public static void clear(HttpSession httpSession) {
        _sessionMaps.clear(httpSession, _CLASS_NAME);
    }

    public static void clear(PortletRequest portletRequest) {
        _sessionMaps.clear(SessionErrors._getPortalHttpSession(portletRequest), SessionErrors._getKey(portletRequest));
    }

    public static boolean contains(HttpServletRequest httpServletRequest, Class<?> clazz) {
        return SessionErrors.contains(SessionErrors._getPortalHttpSession(httpServletRequest), clazz.getName());
    }

    public static boolean contains(HttpServletRequest httpServletRequest, Class<?>[] classes) {
        return SessionErrors.contains(SessionErrors._getPortalHttpSession(httpServletRequest), classes);
    }

    public static boolean contains(HttpServletRequest httpServletRequest, String key) {
        return SessionErrors.contains(SessionErrors._getPortalHttpSession(httpServletRequest), key);
    }

    public static boolean contains(HttpSession httpSession, Class<?> clazz) {
        return SessionErrors.contains(httpSession, clazz.getName());
    }

    public static boolean contains(HttpSession httpSession, Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            if (!SessionErrors.contains(httpSession, clazz.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(HttpSession httpSession, String key) {
        return _sessionMaps.contains(httpSession, _CLASS_NAME, key);
    }

    public static boolean contains(PortletRequest portletRequest, Class<?> clazz) {
        return SessionErrors.contains(portletRequest, clazz.getName());
    }

    public static boolean contains(PortletRequest portletRequest, Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            if (!SessionErrors.contains(portletRequest, clazz.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(PortletRequest portletRequest, String key) {
        return _sessionMaps.contains(SessionErrors._getPortalHttpSession(portletRequest), SessionErrors._getKey(portletRequest), key);
    }

    public static Object get(HttpServletRequest httpServletRequest, Class<?> clazz) {
        return SessionErrors.get(SessionErrors._getPortalHttpSession(httpServletRequest), clazz.getName());
    }

    public static Object get(HttpServletRequest httpServletRequest, String key) {
        return SessionErrors.get(SessionErrors._getPortalHttpSession(httpServletRequest), key);
    }

    public static Object get(HttpSession httpSession, Class<?> clazz) {
        return SessionErrors.get(httpSession, clazz.getName());
    }

    public static Object get(HttpSession httpSession, String key) {
        return _sessionMaps.get(httpSession, _CLASS_NAME, key);
    }

    public static Object get(PortletRequest portletRequest, Class<?> clazz) {
        return SessionErrors.get(portletRequest, clazz.getName());
    }

    public static Object get(PortletRequest portletRequest, String key) {
        return _sessionMaps.get(SessionErrors._getPortalHttpSession(portletRequest), SessionErrors._getKey(portletRequest), key);
    }

    public static boolean isEmpty(HttpServletRequest httpServletRequest) {
        return SessionErrors.isEmpty(SessionErrors._getPortalHttpSession(httpServletRequest));
    }

    public static boolean isEmpty(HttpSession httpSession) {
        return _sessionMaps.isEmpty(httpSession, _CLASS_NAME);
    }

    public static boolean isEmpty(PortletRequest portletRequest) {
        return _sessionMaps.isEmpty(SessionErrors._getPortalHttpSession(portletRequest), SessionErrors._getKey(portletRequest));
    }

    public static Iterator<String> iterator(HttpServletRequest httpServletRequest) {
        return SessionErrors.iterator(SessionErrors._getPortalHttpSession(httpServletRequest));
    }

    public static Iterator<String> iterator(HttpSession httpSession) {
        return _sessionMaps.iterator(httpSession, _CLASS_NAME);
    }

    public static Iterator<String> iterator(PortletRequest portletRequest) {
        return _sessionMaps.iterator(SessionErrors._getPortalHttpSession(portletRequest), SessionErrors._getKey(portletRequest));
    }

    public static Set<String> keySet(HttpServletRequest httpServletRequest) {
        return SessionErrors.keySet(SessionErrors._getPortalHttpSession(httpServletRequest));
    }

    public static Set<String> keySet(HttpSession httpSession) {
        return _sessionMaps.keySet(httpSession, _CLASS_NAME);
    }

    public static Set<String> keySet(PortletRequest portletRequest) {
        return _sessionMaps.keySet(SessionErrors._getPortalHttpSession(portletRequest), SessionErrors._getKey(portletRequest));
    }

    public static void print(HttpServletRequest httpServletRequest) {
        SessionErrors.print(SessionErrors._getPortalHttpSession(httpServletRequest));
    }

    public static void print(HttpSession httpSession) {
        Iterator<String> iterator = SessionErrors.iterator(httpSession);
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    public static void print(PortletRequest portletRequest) {
        Iterator<String> iterator = SessionErrors.iterator(portletRequest);
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    public static void remove(HttpServletRequest httpServletRequest, Class<?> clazz) {
        _sessionMaps.remove(SessionErrors._getPortalHttpSession(httpServletRequest), _CLASS_NAME, clazz.getName());
    }

    public static void remove(HttpServletRequest httpServletRequest, String key) {
        _sessionMaps.remove(SessionErrors._getPortalHttpSession(httpServletRequest), _CLASS_NAME, key);
    }

    public static int size(HttpServletRequest httpServletRequest) {
        return SessionErrors.size(SessionErrors._getPortalHttpSession(httpServletRequest));
    }

    public static int size(HttpSession httpSession) {
        return _sessionMaps.size(httpSession, _CLASS_NAME);
    }

    public static int size(PortletRequest portletRequest) {
        return _sessionMaps.size(SessionErrors._getPortalHttpSession(portletRequest), SessionErrors._getKey(portletRequest));
    }

    private static String _getKey(PortletRequest portletRequest) {
        StringBundler sb = new StringBundler(6);
        LiferayPortletRequest liferayPortletRequest = PortalUtil.getLiferayPortletRequest(portletRequest);
        sb.append("javax.portlet.p.");
        sb.append(liferayPortletRequest.getPortletName());
        sb.append("_LAYOUT_");
        sb.append(liferayPortletRequest.getPlid());
        sb.append("?");
        sb.append(_CLASS_NAME);
        return sb.toString();
    }

    private static HttpSession _getPortalHttpSession(HttpServletRequest httpServletRequest) {
        HttpServletRequest originalHttpServletRequest = PortalUtil.getOriginalServletRequest(httpServletRequest);
        return originalHttpServletRequest.getSession();
    }

    private static HttpSession _getPortalHttpSession(PortletRequest portletRequest) {
        return SessionErrors._getPortalHttpSession(PortalUtil.getHttpServletRequest(portletRequest));
    }
}

