/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.taglib;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.servlet.taglib.TagDynamicInclude;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TagDynamicIncludeUtil {
    private static final Log _log = LogFactoryUtil.getLog(TagDynamicIncludeUtil.class);
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final ServiceTrackerMap<String, List<TagDynamicInclude>> _tagDynamicIncludes = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)_bundleContext, TagDynamicInclude.class, null, (ServiceReferenceMapper)new ServiceReferenceMapper<String, TagDynamicInclude>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void map(ServiceReference<TagDynamicInclude> serviceReference, final ServiceReferenceMapper.Emitter<String> emitter) {
            TagDynamicInclude tagDynamicInclude = (TagDynamicInclude)_bundleContext.getService(serviceReference);
            try {
                tagDynamicInclude.register(new TagDynamicInclude.TagDynamicIncludeRegistry(){

                    @Override
                    public void register(String tagClassName, String tagDynamicId, String tagPoint) {
                        emitter.emit((Object)TagDynamicIncludeUtil._getKey(tagClassName, tagDynamicId, tagPoint));
                    }
                });
            }
            finally {
                _bundleContext.ungetService(serviceReference);
            }
        }
    });

    public static List<TagDynamicInclude> getTagDynamicIncludes(String tagClassName, String tagDynamicId, String tagPoint) {
        return (List)_tagDynamicIncludes.getService((Object)TagDynamicIncludeUtil._getKey(tagClassName, tagDynamicId, tagPoint));
    }

    public static boolean hasTagDynamicInclude(String tagClassName, String tagDynamicId, String tagPoint) {
        return !ListUtil.isEmpty(TagDynamicIncludeUtil.getTagDynamicIncludes(tagClassName, tagDynamicId, tagPoint));
    }

    public static void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String tagClassName, String tagDynamicId, String tagPoint, boolean ascendingPriority) {
        List<TagDynamicInclude> tagDynamicIncludes = TagDynamicIncludeUtil.getTagDynamicIncludes(tagClassName, tagDynamicId, tagPoint);
        if (ListUtil.isEmpty(tagDynamicIncludes)) {
            return;
        }
        Iterator<TagDynamicInclude> iterator = null;
        iterator = ascendingPriority ? tagDynamicIncludes.iterator() : ListUtil.reverseIterator(tagDynamicIncludes);
        while (iterator.hasNext()) {
            TagDynamicInclude tagDynamicInclude = iterator.next();
            try {
                tagDynamicInclude.include(httpServletRequest, httpServletResponse, tagClassName, tagDynamicId, tagPoint);
            }
            catch (Exception exception) {
                _log.error(exception);
            }
        }
    }

    private static String _getKey(String tagClassName, String tagDynamicId, String tagPoint) {
        return StringBundler.concat((Object[])new Object[]{tagClassName, Character.valueOf('#'), tagPoint, Character.valueOf('#'), tagDynamicId});
    }

    private TagDynamicIncludeUtil() {
    }
}

