/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.taglib.aui;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.servlet.taglib.aui.AMDRequire;
import com.liferay.portal.kernel.servlet.taglib.aui.JSFragment;
import com.liferay.portal.kernel.servlet.taglib.aui.PortletData;
import com.liferay.portal.kernel.servlet.taglib.aui.PortletDataRenderer;
import com.liferay.portal.kernel.util.Mergeable;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ScriptData
implements Mergeable<ScriptData>,
Serializable {
    private static volatile PortletDataRenderer _portletDataRenderer;
    private static final ServiceTracker<PortletDataRenderer, PortletDataRenderer> _serviceTracker;
    private static final Pattern _whitespacePattern;
    private static final long serialVersionUID = 1L;
    private final ConcurrentMap<String, PortletData> _portletDataMap = new ConcurrentHashMap<String, PortletData>();

    public void append(String portletId, JSFragment jsFragment) {
        PortletData oldPortletData;
        PortletData portletData;
        if (Validator.isNull(portletId)) {
            portletId = "";
        }
        if ((portletData = (PortletData)this._portletDataMap.get(portletId)) == null && (oldPortletData = this._portletDataMap.putIfAbsent(portletId, portletData = new PortletData())) != null) {
            portletData = oldPortletData;
        }
        portletData.add(jsFragment);
    }

    public void append(String portletId, String content, String modules, ModulesType modulesType) {
        if (Validator.isNull(modules)) {
            this.append(portletId, new JSFragment(content));
        } else if (modulesType == ModulesType.AUI) {
            ArrayList<String> auiModules = new ArrayList<String>();
            for (String module : StringUtil.split(modules)) {
                auiModules.add(StringUtil.trim(module));
            }
            this.append(portletId, new JSFragment(null, auiModules, content, null));
        } else {
            this.append(portletId, new JSFragment(this._parseAMDRequires(modules), null, content, null));
        }
    }

    public void append(String portletId, StringBundler contentSB, String modules, ModulesType modulesType) {
        this.append(portletId, contentSB.toString(), modules, modulesType);
    }

    public void mark() {
        for (PortletData portletData : this._portletDataMap.values()) {
            portletData.mark();
        }
    }

    @Override
    public ScriptData merge(ScriptData scriptData) {
        if (scriptData != null && scriptData != this) {
            this._portletDataMap.putAll(scriptData._portletDataMap);
        }
        return this;
    }

    public void reset() {
        for (PortletData portletData : this._portletDataMap.values()) {
            portletData.reset();
        }
    }

    @Override
    public ScriptData split() {
        return new ScriptData();
    }

    public void writeTo(Writer writer) throws IOException {
        _portletDataRenderer.write(this._portletDataMap.values(), writer);
    }

    public void writeTo(Writer writer, String portletId) throws IOException {
        PortletData portletData = (PortletData)this._portletDataMap.remove(portletId);
        if (portletData == null) {
            return;
        }
        _portletDataRenderer.write(Collections.singleton(portletData), writer);
    }

    protected ConcurrentMap<String, PortletData> getPortletDataMap() {
        return this._portletDataMap;
    }

    private String[] _getNameAndAlias(String requirePart) {
        String[] parts = _whitespacePattern.split(requirePart = requirePart.trim(), 4);
        if (parts.length == 3 && StringUtil.equalsIgnoreCase(parts[1], "as")) {
            return new String[]{parts[0], parts[2]};
        }
        return new String[]{requirePart, null};
    }

    private Collection<AMDRequire> _parseAMDRequires(String require) {
        String[] requireParts;
        ArrayList<AMDRequire> amdRequires = new ArrayList<AMDRequire>();
        for (String requirePart : requireParts = require.split(",")) {
            String[] nameAndAlias = this._getNameAndAlias(requirePart);
            AMDRequire amdRequire = null;
            amdRequire = nameAndAlias[1] == null ? new AMDRequire(nameAndAlias[0]) : new AMDRequire(nameAndAlias[1], nameAndAlias[0]);
            amdRequires.add(amdRequire);
        }
        return amdRequires;
    }

    static {
        _whitespacePattern = Pattern.compile("\\s+");
        final BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        _serviceTracker = new ServiceTracker(bundleContext, PortletDataRenderer.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<PortletDataRenderer, PortletDataRenderer>(){

            public PortletDataRenderer addingService(ServiceReference<PortletDataRenderer> serviceReference) {
                _portletDataRenderer = (PortletDataRenderer)bundleContext.getService(serviceReference);
                return _portletDataRenderer;
            }

            public void modifiedService(ServiceReference<PortletDataRenderer> serviceReference, PortletDataRenderer portletDataRenderer) {
            }

            public void removedService(ServiceReference<PortletDataRenderer> serviceReference, PortletDataRenderer portletDataRenderer) {
                bundleContext.ungetService(serviceReference);
            }
        });
        _serviceTracker.open();
    }

    public static enum ModulesType {
        AUI,
        ES6;

    }
}

