/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.taglib.aui;

import com.liferay.petra.string.StringBundler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class VariableUtil {
    private static final Set<String> _reservedWords = new HashSet<String>(Arrays.asList("arguments", "await", "break", "case", "catch", "class", "const", "continue", "debugger", "default", "delete", "do", "else", "enum", "eval", "export", "extends", "false", "finally", "for", "function", "if", "implements", "import", "in", "instanceof", "interface", "let", "new", "null", "package", "private", "protected", "public", "return", "static", "super", "switch", "this", "throw", "true", "try", "typeof", "var", "void", "while", "with", "yield"));

    public static String generateVariable(String module) {
        return VariableUtil.generateVariable(module, null);
    }

    public static String generateVariable(String module, Set<String> usedVariables) {
        StringBundler sb = new StringBundler(((String)module).length());
        char c = ((String)module).charAt(0);
        boolean modified = true;
        if ('a' <= c && c <= 'z' || c == '_') {
            sb.append(c);
            modified = false;
        } else if ('A' <= c && c <= 'Z') {
            sb.append((char)(c + 32));
        } else {
            sb.append('_');
        }
        boolean startNewWord = false;
        for (int i = 1; i < ((String)module).length(); ++i) {
            c = ((String)module).charAt(i);
            if ('a' <= c && c <= 'z') {
                if (startNewWord) {
                    sb.append((char)(c - 32));
                    startNewWord = false;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if ('A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_') {
                sb.append(c);
                startNewWord = false;
                continue;
            }
            modified = true;
            startNewWord = true;
        }
        String safeName = module;
        if (modified) {
            safeName = sb.toString();
            module = safeName;
        }
        if (_reservedWords.contains(module)) {
            module = "_" + (String)module;
        }
        if (usedVariables != null) {
            int i = 1;
            while (!usedVariables.add((String)module)) {
                module = safeName.concat(String.valueOf(i++));
            }
        }
        return module;
    }
}

