/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.taglib.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Mergeable;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class OutputData
implements Mergeable<OutputData>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<DataKey, StringBundler> _dataMap = new LinkedHashMap<DataKey, StringBundler>();
    private final Set<String> _outputKeys = new LinkedHashSet<String>();

    public void addDataSB(String outputKey, String webKey, StringBundler sb) {
        DataKey dataKey = new DataKey(outputKey, webKey);
        StringBundler mergedSB = this._dataMap.get(dataKey);
        if (mergedSB == null) {
            this._dataMap.put(dataKey, sb);
        } else {
            mergedSB.append(sb);
        }
    }

    public boolean addOutputKey(String outputKey) {
        return this._outputKeys.add(outputKey);
    }

    public StringBundler getDataSB(String outputKey, String webKey) {
        DataKey dataKey = new DataKey(outputKey, webKey);
        return this._dataMap.get(dataKey);
    }

    public StringBundler getMergedDataSB(String webKey) {
        StringBundler mergedSB = null;
        for (Map.Entry<DataKey, StringBundler> entry : this._dataMap.entrySet()) {
            DataKey dataKey = entry.getKey();
            if (!dataKey._webKey.equals(webKey)) continue;
            if (mergedSB == null) {
                mergedSB = entry.getValue();
                continue;
            }
            mergedSB.append(entry.getValue());
        }
        return mergedSB;
    }

    public Set<String> getOutputKeys() {
        return this._outputKeys;
    }

    @Override
    public OutputData merge(OutputData outputData) {
        if (outputData == null || outputData == this) {
            return this;
        }
        for (Map.Entry<DataKey, StringBundler> entry : outputData._dataMap.entrySet()) {
            DataKey dataKey = entry.getKey();
            String outputKey = dataKey._outputKey;
            if (this._outputKeys.contains(outputKey)) continue;
            StringBundler sb = entry.getValue();
            StringBundler mergedSB = this._dataMap.get(dataKey);
            if (mergedSB == null) {
                this._dataMap.put(dataKey, sb);
            } else {
                mergedSB.append(sb);
            }
            if (!outputData._outputKeys.contains(outputKey)) continue;
            this._outputKeys.add(outputKey);
        }
        return this;
    }

    public void setDataSB(String outputKey, String webKey, StringBundler sb) {
        DataKey dataKey = new DataKey(outputKey, webKey);
        this._dataMap.put(dataKey, sb);
    }

    @Override
    public OutputData split() {
        return new OutputData();
    }

    private static class DataKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String _outputKey;
        private final String _webKey;

        public DataKey(String outputKey, String webKey) {
            this._outputKey = GetterUtil.getString(outputKey);
            this._webKey = webKey;
        }

        public boolean equals(Object object) {
            DataKey dataKey = (DataKey)object;
            return this._outputKey.equals(dataKey._outputKey) && this._webKey.equals(dataKey._webKey);
        }

        public int hashCode() {
            return this._outputKey.hashCode() * 11 + this._webKey.hashCode();
        }
    }
}

