/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.template;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;

public class URLTemplateResource
implements TemplateResource {
    private static final Log _log = LogFactoryUtil.getLog(URLTemplateResource.class);
    private String _templateId;
    private URL _templateURL;
    private String _templateURLExternalForm;

    public URLTemplateResource() {
    }

    public URLTemplateResource(String templateId, URL templateURL) {
        if (Validator.isNull(templateId)) {
            throw new IllegalArgumentException("Template ID is null");
        }
        if (templateURL == null) {
            throw new IllegalArgumentException("Template URL is null");
        }
        this._templateId = templateId;
        this._templateURL = templateURL;
        this._templateURLExternalForm = templateURL.toExternalForm();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof URLTemplateResource)) {
            return false;
        }
        URLTemplateResource urlTemplateResource = (URLTemplateResource)object;
        return this._templateId.equals(urlTemplateResource._templateId) && this._templateURLExternalForm.equals(urlTemplateResource._templateURLExternalForm);
    }

    @Override
    public long getLastModified() {
        try {
            return URLUtil.getLastModifiedTime(this._templateURL);
        }
        catch (IOException ioException) {
            _log.error("Unable to get last modified time for template " + this._templateId, ioException);
            return 0L;
        }
    }

    @Override
    public Reader getReader() throws IOException {
        URLConnection urlConnection = this._templateURL.openConnection();
        return new InputStreamReader(urlConnection.getInputStream(), "UTF-8");
    }

    @Override
    public String getTemplateId() {
        return this._templateId;
    }

    public int hashCode() {
        return this._templateId.hashCode() * 11 + this._templateURLExternalForm.hashCode();
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this._templateId = objectInput.readUTF();
        this._templateURLExternalForm = objectInput.readUTF();
        this._templateURL = new URL(this._templateURLExternalForm);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this._templateId);
        objectOutput.writeUTF(this._templateURLExternalForm);
    }
}

