/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.templateparser;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;

public class TemplateNode
extends LinkedHashMap<String, Object> {
    private static final String _RANDOM_ID = StringUtil.randomId();
    private static final Log _log = LogFactoryUtil.getLog(TemplateNode.class);
    private final Map<String, TemplateNode> _childTemplateNodes = new LinkedHashMap<String, TemplateNode>();
    private final List<TemplateNode> _siblingTemplateNodes = new ArrayList<TemplateNode>();
    private final ThemeDisplay _themeDisplay;

    public TemplateNode(ThemeDisplay themeDisplay, String name, String data, String type, Map<String, String> attributes) {
        this._themeDisplay = themeDisplay;
        this.put("attributes", attributes);
        this.put("name", name);
        this.put("data", data);
        this.put("type", type);
        this.put("options", new ArrayList());
        this.put("optionsMap", new LinkedHashMap());
    }

    public void appendChild(TemplateNode templateNode) {
        this._childTemplateNodes.put(templateNode.getName(), templateNode);
        if (Objects.equals(templateNode.getName(), "attributes")) {
            this.put(_RANDOM_ID + "Attributes", this.getAttributes());
        }
        if (Objects.equals(templateNode.getName(), "data")) {
            this.put(_RANDOM_ID + "Data", this._getData());
        }
        if (Objects.equals(templateNode.getName(), "name")) {
            this.put(_RANDOM_ID + "Name", this.getName());
        }
        if (Objects.equals(templateNode.getName(), "options")) {
            this.put(_RANDOM_ID + "Options", this.getOptions());
        }
        if (Objects.equals(templateNode.getName(), "optionsMap")) {
            this.put(_RANDOM_ID + "OptionsMap", this.getOptionsMap());
        }
        if (Objects.equals(templateNode.getName(), "type")) {
            this.put(_RANDOM_ID + "Type", this.getType());
        }
        this.put(templateNode.getName(), templateNode);
    }

    public void appendChildren(List<TemplateNode> templateNodes) {
        for (TemplateNode templateNode : templateNodes) {
            this.appendChild(templateNode);
        }
    }

    public void appendOption(String option) {
        List<String> options = this.getOptions();
        options.add(option);
    }

    public void appendOptionMap(String value, String label) {
        Map<String, String> optionsMap = this.getOptionsMap();
        optionsMap.put(value, label);
    }

    public void appendOptions(List<String> options) {
        List<String> curOptions = this.getOptions();
        curOptions.addAll(options);
    }

    public void appendOptionsMap(Map<String, String> optionMap) {
        Map<String, String> optionsMap = this.getOptionsMap();
        optionsMap.putAll(optionMap);
    }

    public void appendSibling(TemplateNode templateNode) {
        this._siblingTemplateNodes.add(templateNode);
    }

    @Override
    public Object clone() {
        TemplateNode templateNode = new TemplateNode(this._themeDisplay, this.getName(), this.getData(), this.getType(), this.getAttributes());
        for (Map.Entry<String, TemplateNode> entry : this._childTemplateNodes.entrySet()) {
            templateNode.appendChild(entry.getValue());
        }
        templateNode.appendOptions(this.getOptions());
        templateNode.appendOptionsMap(this.getOptionsMap());
        for (TemplateNode templateNode2 : this._siblingTemplateNodes) {
            templateNode.appendSibling(templateNode2);
        }
        for (Map.Entry entry : this.entrySet()) {
            templateNode.put((String)entry.getKey(), entry.getValue());
        }
        return templateNode;
    }

    public String getAttribute(String name) {
        Map<String, String> attributes = this.getAttributes();
        if (attributes == null) {
            return "";
        }
        return attributes.get(name);
    }

    public Map<String, String> getAttributes() {
        if (super.containsKey(_RANDOM_ID + "Attributes") || MapUtil.isNotEmpty((Map)this.get(_RANDOM_ID + "Attributes"))) {
            return (Map)this.get(_RANDOM_ID + "Attributes");
        }
        return (Map)this.get("attributes");
    }

    public TemplateNode getChild(String name) {
        return this._childTemplateNodes.get(name);
    }

    public List<TemplateNode> getChildren() {
        return new ArrayList<TemplateNode>(this._childTemplateNodes.values());
    }

    public String getData() {
        String type = this.getType();
        if (type.equals("color") || type.equals("ddm-color")) {
            return this._getColorData();
        }
        if (type.equals("ddm-decimal") || type.equals("ddm-number") || type.equals("numeric")) {
            return this._getNumericData();
        }
        if (type.equals("ddm-journal-article") || type.equals("journal_article")) {
            return this._getLatestArticleData();
        }
        if (type.equals("document_library") || type.equals("image")) {
            return this._getFileEntryData();
        }
        if (type.equals("geolocation")) {
            return this._getGeolocationData();
        }
        return this._getData();
    }

    public String getFriendlyUrl() {
        String type = this.getType();
        if (type.equals("ddm-journal-article") || type.equals("journal_article")) {
            return this._getDDMJournalArticleFriendlyURL();
        }
        if (type.equals("ddm-link-to-page") || type.equals("link_to_layout")) {
            return this.getUrl();
        }
        return "";
    }

    public String getName() {
        if (super.containsKey(_RANDOM_ID + "Name")) {
            return (String)this.get(_RANDOM_ID + "Name");
        }
        Object name = this.get("name");
        if (name == null || name instanceof String) {
            return (String)name;
        }
        return "name";
    }

    public List<String> getOptions() {
        if (super.containsKey(_RANDOM_ID + "Options") || ListUtil.isNotEmpty((List)this.get(_RANDOM_ID + "Options"))) {
            return (List)this.get(_RANDOM_ID + "Options");
        }
        return (List)this.get("options");
    }

    public Map<String, String> getOptionsMap() {
        if (super.containsKey(_RANDOM_ID + "OptionsMap") || MapUtil.isNotEmpty((Map)this.get(_RANDOM_ID + "OptionsMap"))) {
            return (Map)this.get(_RANDOM_ID + "OptionsMap");
        }
        return (Map)this.get("optionsMap");
    }

    public List<TemplateNode> getSiblings() {
        return this._siblingTemplateNodes;
    }

    public String getType() {
        if (super.containsKey(_RANDOM_ID + "Type") || Validator.isNotNull((String)this.get(_RANDOM_ID + "Type"))) {
            return (String)this.get(_RANDOM_ID + "Type");
        }
        Object type = this.get("type");
        if (type == null || type instanceof String) {
            return (String)type;
        }
        return "";
    }

    public String getUrl() {
        if (this._themeDisplay == null) {
            return "";
        }
        String data = this._getData();
        if (!JSONUtil.isJSONObject(data)) {
            return "";
        }
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject(data);
            Layout layout = LayoutLocalServiceUtil.fetchLayout(jsonObject.getLong("groupId"), jsonObject.getBoolean("privateLayout"), jsonObject.getLong("layoutId"));
            if (layout == null) {
                return "";
            }
            return PortalUtil.getLayoutRelativeURL(layout, this._themeDisplay);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug("Unable to parse JSON from data: " + data);
            }
            return "";
        }
    }

    private String _getColorData() {
        String data = this._getData();
        if (data.startsWith("#")) {
            return data;
        }
        return "#" + data;
    }

    private String _getData() {
        if (super.containsKey(_RANDOM_ID + "Data") || Validator.isNotNull((String)this.get(_RANDOM_ID + "Data"))) {
            return (String)this.get(_RANDOM_ID + "Data");
        }
        return (String)this.get("data");
    }

    private String _getDDMJournalArticleFriendlyURL() {
        if (this._themeDisplay == null) {
            return "";
        }
        String data = this._getData();
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject(data);
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(jsonObject.getString("className"));
            if (assetRendererFactory == null) {
                return "";
            }
            long classPK = GetterUtil.getLong(jsonObject.getLong("classPK"));
            AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(classPK);
            if (assetRenderer == null) {
                return "";
            }
            HttpServletRequest httpServletRequest = this._themeDisplay.getRequest();
            PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
            PortletResponse portletResponse = (PortletResponse)httpServletRequest.getAttribute("javax.portlet.response");
            return assetRenderer.getURLViewInContext(PortalUtil.getLiferayPortletRequest(portletRequest), PortalUtil.getLiferayPortletResponse(portletResponse), "");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return "";
        }
    }

    private String _getFileEntryData() {
        String data = this._getData();
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject(data);
            String uuid = jsonObject.getString("uuid");
            long groupId = jsonObject.getLong("groupId");
            if (Validator.isNull(uuid) && groupId == 0L) {
                return "";
            }
            FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId(uuid, groupId);
            return DLUtil.getPreviewURL(fileEntry, fileEntry.getFileVersion(), this._themeDisplay, "", false, false);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return "";
        }
    }

    private String _getGeolocationData() {
        String data = this._getData();
        if (Validator.isNull(data)) {
            return "";
        }
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject(data);
            if (jsonObject.has("latitude") && jsonObject.has("longitude")) {
                return data;
            }
            if (!jsonObject.has("lat") || !jsonObject.has("lng")) {
                return data;
            }
            jsonObject.put("latitude", jsonObject.get("lat")).put("longitude", jsonObject.get("lng"));
            return jsonObject.toString();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return "";
        }
    }

    private String _getLatestArticleData() {
        block8: {
            String data = this._getData();
            try {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject(data);
                AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(jsonObject.getString("className"));
                if (assetRendererFactory == null) {
                    return "";
                }
                long classPK = GetterUtil.getLong(jsonObject.getLong("classPK"));
                AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(classPK);
                if (assetRenderer == null) {
                    return "";
                }
                if (Objects.equals(jsonObject.getString("uuid"), assetRenderer.getUuid())) {
                    return data;
                }
                String updatedTitle = assetRenderer.getTitle(LocaleUtil.fromLanguageId(assetRenderer.getDefaultLanguageId()));
                jsonObject.put("title", updatedTitle);
                HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
                for (String languageId : assetRenderer.getAvailableLanguageIds()) {
                    Locale locale = LocaleUtil.fromLanguageId(languageId);
                    if (locale == null) continue;
                    titleMap.put(locale, assetRenderer.getTitle(locale));
                }
                jsonObject.put("titleMap", titleMap).put("uuid", assetRenderer.getUuid());
                return jsonObject.toString();
            }
            catch (JSONException jsonException) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Unable to parse JSON from data: " + data);
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block8;
                _log.debug(exception);
            }
        }
        return this._getData();
    }

    private String _getNumericData() {
        String data = this._getData();
        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance(LocaleUtil.getMostRelevantLocale());
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        decimalFormatSymbols.setZeroDigit('0');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
        decimalFormat.setParseBigDecimal(true);
        return decimalFormat.format(GetterUtil.getDouble(data));
    }
}

