/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public abstract class BaseAdminPortletsUpgradeProcess
extends UpgradeProcess {
    protected void addResourcePermission(long resourcePermissionId, long companyId, String name, int scope, String primKey, long roleId, long actionIds) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into ResourcePermission (resourcePermissionId, ", "companyId, name, scope, primKey, primKeyId, roleId, ", "actionIds, viewActionId) values (?, ?, ?, ?, ?, ?, ?, ?, ", "?)"}));){
            boolean viewActionId = false;
            if (actionIds % 2L == 1L) {
                viewActionId = true;
            }
            preparedStatement.setLong(1, resourcePermissionId);
            preparedStatement.setLong(2, companyId);
            preparedStatement.setString(3, name);
            preparedStatement.setInt(4, scope);
            preparedStatement.setString(5, primKey);
            preparedStatement.setLong(6, GetterUtil.getLong(primKey));
            preparedStatement.setLong(7, roleId);
            preparedStatement.setLong(8, actionIds);
            preparedStatement.setBoolean(9, viewActionId);
            preparedStatement.executeUpdate();
        }
    }

    protected long getBitwiseValue(String name, String actionId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select bitwiseValue from ResourceAction where name = ? and actionId = ?");){
            long l;
            block16: {
                ResultSet resultSet;
                block14: {
                    long l2;
                    block15: {
                        preparedStatement.setString(1, name);
                        preparedStatement.setString(2, actionId);
                        resultSet = preparedStatement.executeQuery();
                        try {
                            if (!resultSet.next()) break block14;
                            l2 = resultSet.getLong("bitwiseValue");
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return l2;
                }
                l = 0L;
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return l;
        }
    }

    protected long getControlPanelGroupId() throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select groupId from Group_ where name = 'Control Panel'");){
            long l;
            block16: {
                ResultSet resultSet;
                block14: {
                    long l2;
                    block15: {
                        resultSet = preparedStatement.executeQuery();
                        try {
                            if (!resultSet.next()) break block14;
                            l2 = resultSet.getLong("groupId");
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return l2;
                }
                l = 0L;
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return l;
        }
    }

    protected void updateAccessInControlPanelPermission(String portletFrom, String portletTo) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long bitwiseValue = this.getBitwiseValue(portletFrom, "ACCESS_IN_CONTROL_PANEL");
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("select * from ResourcePermission where name = ?");){
                preparedStatement.setString(1, portletFrom);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        long actionIds = resultSet.getLong("actionIds");
                        if ((actionIds & bitwiseValue) == 0L) continue;
                        long resourcePermissionId = resultSet.getLong("resourcePermissionId");
                        this.runSQL(StringBundler.concat((Object[])new Object[]{"update ResourcePermission set actionIds = ", actionIds &= bitwiseValue ^ 0xFFFFFFFFFFFFFFFFL, " where resourcePermissionId = ", resourcePermissionId}));
                        resourcePermissionId = this.increment(ResourcePermission.class.getName());
                        long companyId = resultSet.getLong("companyId");
                        int scope = resultSet.getInt("scope");
                        String primKey = resultSet.getString("primKey");
                        long roleId = resultSet.getLong("roleId");
                        actionIds = resultSet.getLong("actionIds");
                        this.addResourcePermission(resourcePermissionId, companyId, portletTo, scope, primKey, roleId, actionIds |= bitwiseValue);
                    }
                }
            }
        }
    }
}

