/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.SQLException;
import java.util.HashSet;

public abstract class BaseDBColumnSizeUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(BaseDBColumnSizeUpgradeProcess.class);
    private final DBType _dbType;
    private final String _oldColumnType;
    private final int _size;

    public BaseDBColumnSizeUpgradeProcess(DBType dbType, String oldColumnType, int size) {
        this._dbType = dbType;
        this._oldColumnType = oldColumnType;
        this._size = size;
    }

    @Override
    protected void doUpgrade() throws Exception {
        if (DBManagerUtil.getDBType() == this._dbType) {
            this._upgradeTables();
        }
    }

    protected abstract void upgradeColumn(String var1, String var2) throws Exception;

    /*
     * Unable to fully structure code
     */
    private void _upgradeTables() throws Exception {
        databaseMetaData = this.connection.getMetaData();
        dbInspector = new DBInspector(this.connection);
        catalog = dbInspector.getCatalog();
        schema = dbInspector.getSchema();
        loggingTimer = new LoggingTimer();
        try {
            tableResultSet = databaseMetaData.getTables(catalog, schema, null, new String[]{"TABLE"});
lbl8:
            // 2 sources

            try {
                block27: while (tableResultSet.next()) {
                    tableName = dbInspector.normalizeName(tableResultSet.getString("TABLE_NAME"));
                    invalidColumnNames = new HashSet<String>();
                    primaryKeyResultSet = databaseMetaData.getPrimaryKeys(catalog, schema, tableName);
                    try {
                        while (primaryKeyResultSet.next()) {
                            primaryKeyName = StringUtil.toUpperCase(primaryKeyResultSet.getString("COLUMN_NAME"));
                            invalidColumnNames.add(primaryKeyName);
                        }
                    }
                    finally {
                        if (primaryKeyResultSet != null) {
                            primaryKeyResultSet.close();
                        }
                    }
                    db = DBManagerUtil.getDB();
                    indexResultSet = db.getIndexResultSet(this.connection, tableName, false);
                    try {
                        while (indexResultSet.next()) {
                            invalidColumnNames.add(StringUtil.toUpperCase(indexResultSet.getString("COLUMN_NAME")));
                        }
                    }
                    finally {
                        if (indexResultSet != null) {
                            indexResultSet.close();
                        }
                    }
                    columnResultSet = databaseMetaData.getColumns(catalog, schema, tableName, null);
                    block30: while (true) {
                        while (columnResultSet.next()) {
                            size = columnResultSet.getInt("COLUMN_SIZE");
                            if (size != this._size || !StringUtil.equalsIgnoreCase(this._oldColumnType, columnResultSet.getString("TYPE_NAME")) || invalidColumnNames.contains(StringUtil.toUpperCase(columnName = columnResultSet.getString("COLUMN_NAME")))) continue;
                            try {
                                this.upgradeColumn(tableName, columnName);
                                continue block30;
                            }
                            catch (SQLException sqlException) {
                                if (!BaseDBColumnSizeUpgradeProcess._log.isWarnEnabled()) continue;
                                BaseDBColumnSizeUpgradeProcess._log.warn(StringBundler.concat((String[])new String[]{"Unable to alter length of column ", columnName, " for table ", tableName}), sqlException);
                            }
                        }
                        continue block27;
                        {
                            continue block30;
                            break;
                        }
                        break;
                    }
                    finally {
                        if (columnResultSet == null) ** GOTO lbl8
                        columnResultSet.close();
                    }
                }
            }
            finally {
                if (tableResultSet != null) {
                    tableResultSet.close();
                }
            }
        }
        finally {
            loggingTimer.close();
        }
    }
}

