/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.resource.bundle.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ClassResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public abstract class BaseLocalizedColumnUpgradeProcess
extends UpgradeProcess {
    private static final Set<String> _alteredTableNameColumnNames = new HashSet<String>();

    protected void upgradeLocalizedColumn(ResourceBundleLoader resourceBundleLoader, String tableName, String columnName, String originalContent, String localizationMapKey, String localizationXMLKey, long[] companyIds) throws SQLException {
        try {
            if (!this.hasColumnType(tableName, columnName, "TEXT null") && !_alteredTableNameColumnNames.contains(tableName + "#" + columnName)) {
                this.alterColumnType(tableName, columnName, "TEXT null");
                _alteredTableNameColumnNames.add(tableName + "#" + columnName);
            }
            Class<?> clazz = this.getClass();
            CompanyLocalServiceUtil.forEachCompanyId(companyId -> this._upgrade(new AggregateResourceBundleLoader(new ClassResourceBundleLoader("content.Language", clazz.getClassLoader()), resourceBundleLoader), tableName, columnName, originalContent, localizationMapKey, localizationXMLKey, (long)companyId), companyIds);
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    private String _getLocalizationXML(String localizationMapKey, String localizationXMLKey, long companyId, ResourceBundleLoader resourceBundleLoader) throws SQLException {
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable(companyId);){
            String string = LocalizationUtil.updateLocalization(ResourceBundleUtil.getLocalizationMap(resourceBundleLoader, localizationMapKey), "", localizationXMLKey, UpgradeProcessUtil.getDefaultLanguageId(companyId));
            return string;
        }
    }

    private void _upgrade(ResourceBundleLoader resourceBundleLoader, String tableName, String columnName, String originalContent, String localizationMapKey, String localizationXMLKey, long companyId) throws SQLException {
        String localizationXML = this._getLocalizationXML(localizationMapKey, localizationXMLKey, companyId, resourceBundleLoader);
        String sql = StringBundler.concat((String[])new String[]{"update ", tableName, " set ", columnName, " = ? where ", columnName, " like ? and companyId = ?"});
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
            preparedStatement.setString(1, localizationXML);
            preparedStatement.setString(2, originalContent);
            preparedStatement.setLong(3, companyId);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sqlException) {
            throw new SystemException(sqlException);
        }
    }
}

