/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.BasePortletIdUpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseReplacePortletId
extends BasePortletIdUpgradeProcess {
    @Override
    protected void doUpgrade() throws Exception {
        HashMap<String, List> renamePortletIdsMap = new HashMap<String, List>();
        for (String[] renamePortletIds : this.getRenamePortletIdsArray()) {
            List sourcePortletIds = renamePortletIdsMap.computeIfAbsent(renamePortletIds[1], key -> new ArrayList());
            sourcePortletIds.add(renamePortletIds[0]);
        }
        ArrayList<String> clauses = new ArrayList<String>();
        for (Map.Entry entry : renamePortletIdsMap.entrySet()) {
            List sourcePortletIds = (List)entry.getValue();
            if (sourcePortletIds.size() <= 1) continue;
            for (int i = 0; i < sourcePortletIds.size() - 1; ++i) {
                String portletId1 = (String)sourcePortletIds.get(i);
                for (int j = i + 1; j < sourcePortletIds.size(); ++j) {
                    String portletId2 = (String)sourcePortletIds.get(j);
                    clauses.add(String.format("((PP1.portletId = '%s') AND (PP2.portletId = '%s'))", portletId1, portletId2));
                }
            }
        }
        if (!clauses.isEmpty()) {
            String orClauses = StringUtil.merge(clauses, " OR ");
            this._deleteConflictingPreferences(orClauses);
        }
        super.doUpgrade();
    }

    protected boolean hasPortlet(String portletId) throws SQLException {
        return this.hasRow("select count(*) from Portlet where portletId = ?", portletId);
    }

    protected boolean hasResourceAction(String name) throws SQLException {
        return this.hasRow("select count(*) from ResourceAction where name = ?", name);
    }

    protected boolean hasResourcePermission(String name) throws SQLException {
        return this.hasRow("select count(*) from ResourcePermission where name = ?", name);
    }

    protected boolean hasRow(String sql, String value) throws SQLException {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
            boolean bl;
            block16: {
                ResultSet resultSet;
                block14: {
                    boolean bl2;
                    block15: {
                        preparedStatement.setString(1, value);
                        resultSet = preparedStatement.executeQuery();
                        try {
                            int count;
                            if (!resultSet.next() || (count = resultSet.getInt(1)) <= 0) break block14;
                            bl2 = true;
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return bl2;
                }
                bl = false;
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return bl;
        }
    }

    @Override
    protected void updatePortletId(String oldRootPortletId, String newRootPortletId) throws Exception {
        if (!this.hasPortlet(newRootPortletId)) {
            super.updatePortletId(oldRootPortletId, newRootPortletId);
        }
    }

    @Override
    protected void updateResourceAction(String oldName, String newName) throws Exception {
        if (this.hasResourceAction(newName)) {
            try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select RA1.resourceActionId from ResourceAction ", "RA1 inner join ResourceAction RA2 on ", "RA1.actionId = RA2.actionId where RA1.name = ? ", "and RA2.name = ?"}));
                 PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, "delete from ResourceAction where resourceActionId = ?");){
                preparedStatement1.setString(1, oldName);
                preparedStatement1.setString(2, newName);
                ResultSet resultSet = preparedStatement1.executeQuery();
                int deleteCount = 0;
                while (resultSet.next()) {
                    preparedStatement2.setLong(1, resultSet.getLong(1));
                    preparedStatement2.addBatch();
                    ++deleteCount;
                }
                if (deleteCount > 0) {
                    preparedStatement2.executeBatch();
                }
            }
        }
        super.updateResourceAction(oldName, newName);
    }

    @Override
    protected void updateResourcePermission(String oldRootPortletId, String newRootPortletId, boolean updateName) throws Exception {
        if (this.hasResourcePermission(newRootPortletId)) {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("delete from ResourcePermission where name = ?");){
                preparedStatement.setString(1, oldRootPortletId);
                preparedStatement.execute();
            }
        } else {
            super.updateResourcePermission(oldRootPortletId, newRootPortletId, updateName);
        }
    }

    private void _deleteConflictingPreferences(String orClauses) throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select PP1.portletPreferencesId from PortletPreferences ", "PP1 inner join PortletPreferences PP2 on PP1.plid = ", "PP2.plid where ", orClauses}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, "delete from PortletPreferences where portletPreferencesId = ?");){
            ResultSet resultSet = preparedStatement1.executeQuery();
            int deleteCount = 0;
            while (resultSet.next()) {
                preparedStatement2.setLong(1, resultSet.getLong(1));
                preparedStatement2.addBatch();
                ++deleteCount;
            }
            if (deleteCount > 0) {
                preparedStatement2.executeBatch();
            }
        }
    }
}

