/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;

public class BaseStagingGroupTypeSettingsUpgradeProcess
extends UpgradeProcess {
    private final CompanyLocalService _companyLocalService;
    private final GroupLocalService _groupLocalService;
    private final String _newPortletId;
    private final String _oldPortletId;

    public BaseStagingGroupTypeSettingsUpgradeProcess(CompanyLocalService companyLocalService, GroupLocalService groupLocalService, String oldPortletId, String newPortletId) {
        this._companyLocalService = companyLocalService;
        this._groupLocalService = groupLocalService;
        this._oldPortletId = oldPortletId;
        this._newPortletId = newPortletId;
    }

    @Override
    protected void doUpgrade() throws Exception {
        this.updateStagedPortletNames();
    }

    protected void updateStagedPortletNames() throws PortalException {
        this._companyLocalService.forEachCompanyId(companyId -> this.updateStagedPortletNames((Long)companyId));
    }

    protected void updateStagedPortletNames(Long companyId) throws PortalException {
        ActionableDynamicQuery groupActionableDynamicQuery = this._groupLocalService.getActionableDynamicQuery();
        groupActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property companyIdProperty = PropertyFactoryUtil.forName("companyId");
            dynamicQuery.add(companyIdProperty.eq(companyId));
            Property siteProperty = PropertyFactoryUtil.forName("site");
            dynamicQuery.add(siteProperty.eq(Boolean.TRUE));
        });
        groupActionableDynamicQuery.setPerformActionMethod(group -> {
            UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
            if (typeSettingsUnicodeProperties.isEmpty()) {
                return;
            }
            String oldPropertyKey = this._getStagedPortletId(this._oldPortletId);
            String oldPropertyValue = typeSettingsUnicodeProperties.getProperty(oldPropertyKey);
            typeSettingsUnicodeProperties.remove(oldPropertyKey);
            if (Validator.isNull(oldPropertyValue)) {
                return;
            }
            String newPropertyKey = this._getStagedPortletId(this._newPortletId);
            String newPropertyValue = typeSettingsUnicodeProperties.getProperty(newPropertyKey);
            if (Validator.isNull(newPropertyValue)) {
                typeSettingsUnicodeProperties.put(newPropertyKey, oldPropertyValue);
            }
            group.setTypeSettingsProperties(typeSettingsUnicodeProperties);
            this._groupLocalService.updateGroup((Group)group);
        });
        groupActionableDynamicQuery.performActions();
    }

    private String _getStagedPortletId(String portletId) {
        if (portletId.startsWith("staged-portlet_")) {
            return portletId;
        }
        return "staged-portlet_".concat(portletId);
    }
}

