/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public abstract class BaseStaleUserIdUpgradeProcess
extends UpgradeProcess {
    private final UserLocalService _userLocalService;

    public BaseStaleUserIdUpgradeProcess(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    protected void upgradeUserId(String columnName, String tableName) throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select ", tableName, ".", columnName, ", ", tableName, ".companyId from ", tableName, " left join User_ on ", tableName, ".userId = User_.userId where User_.userId is null"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, StringBundler.concat((String[])new String[]{"update ", tableName, " set userId = ? where ", columnName, " = ?"}));
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                preparedStatement2.setLong(1, this._userLocalService.getUserIdByScreenName(resultSet.getLong("companyId"), "default-service-account"));
                preparedStatement2.setLong(2, resultSet.getLong(columnName));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

