/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class GuestUnsupportedResourcePermissionsUpgradeProcess
extends UpgradeProcess {
    private final String[] _guestUnsupportedResourceActionIds;
    private final String _resourceName;

    public GuestUnsupportedResourcePermissionsUpgradeProcess(String resourceName, String ... guestUnsupportedResourceActionIds) {
        this._resourceName = resourceName;
        this._guestUnsupportedResourceActionIds = guestUnsupportedResourceActionIds;
    }

    @Override
    protected void doUpgrade() throws Exception {
        long bitmask = this._getBitmask();
        CompanyLocalServiceUtil.forEachCompanyId(companyId -> this._removeGuestUnsupportedResourcePermissions(bitmask, (long)companyId));
    }

    private long _getBitmask() throws Exception {
        long bitmask = -1L;
        StringBundler sb = new StringBundler(2 + this._guestUnsupportedResourceActionIds.length);
        sb.append("select bitwiseValue from ResourceAction where name = ? ");
        sb.append("and (");
        for (int i = 1; i < this._guestUnsupportedResourceActionIds.length; ++i) {
            sb.append("actionId = ? or ");
        }
        sb.append("actionId = ?)");
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sb.toString());){
            preparedStatement.setString(1, this._resourceName);
            for (int i = 0; i < this._guestUnsupportedResourceActionIds.length; ++i) {
                preparedStatement.setString(i + 2, this._guestUnsupportedResourceActionIds[i]);
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    bitmask &= resultSet.getLong("bitwiseValue") ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
        }
        return bitmask;
    }

    private long _getGuestRoleId(long companyId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select ctCollectionId, roleId from Role_ where companyId = ? and name = ?");){
            long l;
            block13: {
                preparedStatement.setLong(1, companyId);
                preparedStatement.setString(2, "Guest");
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    if (!resultSet.next()) {
                        throw new IllegalStateException("Unable to find Guest role for company " + companyId);
                    }
                    l = resultSet.getLong("roleId");
                    if (resultSet == null) break block13;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return l;
        }
    }

    private void _removeGuestUnsupportedResourcePermissions(long bitmask, long companyId) throws Exception {
        long guestRoleId = this._getGuestRoleId(companyId);
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select resourcePermissionId, ctCollectionId, actionIds from ResourcePermission where companyId = ? and name = ? and roleId = ?");){
            preparedStatement1.setLong(1, companyId);
            preparedStatement1.setString(2, this._resourceName);
            preparedStatement1.setLong(3, guestRoleId);
            try (ResultSet resultSet = preparedStatement1.executeQuery();
                 PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, "update ResourcePermission set actionIds = ? where resourcePermissionId = ? and ctCollectionId = ?");){
                while (resultSet.next()) {
                    preparedStatement2.setLong(1, resultSet.getLong("actionIds") & bitmask);
                    preparedStatement2.setLong(2, resultSet.getLong("resourcePermissionId"));
                    preparedStatement2.setLong(3, resultSet.getLong("ctCollectionId"));
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
        if (!ArrayUtil.contains(this._guestUnsupportedResourceActionIds, "VIEW")) {
            return;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update ResourcePermission set viewActionId = 0 where companyId = ? and name = ? and roleId = ?");){
            preparedStatement.setLong(1, companyId);
            preparedStatement.setString(2, this._resourceName);
            preparedStatement.setLong(3, guestRoleId);
            preparedStatement.executeUpdate();
        }
    }
}

