/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade.recorder;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.util.CallableStatementWrapper;
import com.liferay.portal.kernel.dao.jdbc.util.ConnectionWrapper;
import com.liferay.portal.kernel.dao.jdbc.util.PreparedStatementWrapper;
import com.liferay.portal.kernel.dao.jdbc.util.StatementWrapper;
import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public class UpgradeSQLRecorder {
    private static final long _UPGRADE_REPORT_SQL_STATEMENT_THRESHOLD = GetterUtil.getLong(PropsUtil.get("upgrade.report.sql.statement.threshold"));
    private static boolean _enabled;
    private static final List<FailedSQL> _failedSQLs;
    private static final Set<RunningSQL> _runningSQLs;
    private static volatile String _upgradeProcessClassName;

    public static Connection getConnectionWrapper(Connection connection) {
        return UpgradeSQLRecorder.getConnectionWrapper(connection, "");
    }

    public static Connection getConnectionWrapper(Connection connection, String upgradeProcessClassName) {
        _upgradeProcessClassName = upgradeProcessClassName;
        if (!_enabled) {
            return connection;
        }
        return new ConnectionWrapper(connection){

            @Override
            public Statement createStatement() throws SQLException {
                return UpgradeSQLRecorder._wrap(super.createStatement());
            }

            @Override
            public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
                return UpgradeSQLRecorder._wrap(super.createStatement(resultSetType, resultSetConcurrency));
            }

            @Override
            public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                return UpgradeSQLRecorder._wrap(super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
            }

            @Override
            public CallableStatement prepareCall(String sql) throws SQLException {
                return UpgradeSQLRecorder._wrap(super.prepareCall(sql));
            }

            @Override
            public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
                return UpgradeSQLRecorder._wrap(super.prepareCall(sql, resultSetType, resultSetConcurrency));
            }

            @Override
            public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                return UpgradeSQLRecorder._wrap(super.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
            }

            @Override
            public PreparedStatement prepareStatement(String sql) throws SQLException {
                return UpgradeSQLRecorder._wrap(super.prepareStatement(sql));
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
                return UpgradeSQLRecorder._wrap(super.prepareStatement(sql, autoGeneratedKeys));
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
                return UpgradeSQLRecorder._wrap(super.prepareStatement(sql, resultSetType, resultSetConcurrency));
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                return UpgradeSQLRecorder._wrap(super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
                return UpgradeSQLRecorder._wrap(super.prepareStatement(sql, columnIndexes));
            }

            @Override
            public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
                return UpgradeSQLRecorder._wrap(super.prepareStatement(sql, columnNames));
            }
        };
    }

    public static List<FailedSQL> getFailedSQLs() {
        return _failedSQLs;
    }

    public static Set<RunningSQL> getRunningSQLs() {
        return _runningSQLs;
    }

    public static void start() {
        _enabled = true;
        _failedSQLs.clear();
        _runningSQLs.clear();
    }

    public static void stop() {
        _enabled = false;
    }

    private static <T> T _execute(SQLCallable<T> sqlCallable, Object object) throws SQLException {
        long startTime = System.currentTimeMillis();
        try {
            T t = sqlCallable.call();
            return t;
        }
        catch (SQLException sqlException) {
            Object sql = UpgradeSQLRecorder._extractSQL(object);
            if (sql != null) {
                sql = (String)sql + ";";
                String message = sqlException.getMessage();
                if (Validator.isBlank(message)) {
                    _failedSQLs.add(new FailedSQL((String)sql));
                } else {
                    _failedSQLs.add(new FailedSQL(message, (String)sql));
                }
            }
            throw sqlException;
        }
        finally {
            UpgradeSQLRecorder._executeFinally(object, startTime);
        }
    }

    private static void _executeFinally(Object object, long startTime) {
        Object sql = UpgradeSQLRecorder._extractSQL(object);
        if (sql == null) {
            return;
        }
        sql = (String)sql + ";";
        long duration = System.currentTimeMillis() - startTime;
        if (duration < _UPGRADE_REPORT_SQL_STATEMENT_THRESHOLD) {
            return;
        }
        if (Validator.isBlank(_upgradeProcessClassName)) {
            _runningSQLs.add(new RunningSQL(duration, (String)sql));
        } else if (DBPartition.isPartitionEnabled()) {
            _runningSQLs.add(new RunningSQL(duration, (String)sql, _upgradeProcessClassName + "@" + String.valueOf(CompanyThreadLocal.getCompanyId())));
        } else {
            _runningSQLs.add(new RunningSQL(duration, (String)sql, _upgradeProcessClassName));
        }
    }

    private static String _extractSQL(Object object) {
        String string;
        int index;
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Statement && (index = (string = object.toString()).indexOf(58)) >= 0) {
            return StringUtil.trim(string.substring(index + 1));
        }
        return null;
    }

    private static <T extends Statement> T _wrap(final T statement) {
        if (statement instanceof CallableStatement) {
            return (T)new CallableStatementWrapper((CallableStatement)statement){

                @Override
                public boolean execute() throws SQLException {
                    return UpgradeSQLRecorder._execute(() -> super.execute(), statement);
                }

                @Override
                public int[] executeBatch() throws SQLException {
                    return UpgradeSQLRecorder._execute(() -> super.executeBatch(), statement);
                }

                @Override
                public ResultSet executeQuery() throws SQLException {
                    return UpgradeSQLRecorder._execute(() -> super.executeQuery(), statement);
                }

                @Override
                public int executeUpdate() throws SQLException {
                    return UpgradeSQLRecorder._execute(() -> super.executeUpdate(), statement);
                }
            };
        }
        if (statement instanceof PreparedStatement) {
            return (T)new PreparedStatementWrapper((PreparedStatement)statement){

                @Override
                public boolean execute() throws SQLException {
                    return UpgradeSQLRecorder._execute(() -> super.execute(), statement);
                }

                @Override
                public int[] executeBatch() throws SQLException {
                    return UpgradeSQLRecorder._execute(() -> super.executeBatch(), statement);
                }

                @Override
                public ResultSet executeQuery() throws SQLException {
                    return UpgradeSQLRecorder._execute(() -> super.executeQuery(), statement);
                }

                @Override
                public int executeUpdate() throws SQLException {
                    return UpgradeSQLRecorder._execute(() -> super.executeUpdate(), statement);
                }
            };
        }
        return (T)new StatementWrapper(statement){

            @Override
            public boolean execute(String sql) throws SQLException {
                return UpgradeSQLRecorder._execute(() -> super.execute(sql), sql);
            }

            @Override
            public int[] executeBatch() throws SQLException {
                return UpgradeSQLRecorder._execute(() -> super.executeBatch(), statement);
            }

            @Override
            public ResultSet executeQuery(String sql) throws SQLException {
                return UpgradeSQLRecorder._execute(() -> super.executeQuery(sql), sql);
            }

            @Override
            public int executeUpdate(String sql) throws SQLException {
                return UpgradeSQLRecorder._execute(() -> super.executeUpdate(sql), sql);
            }

            @Override
            public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
                return UpgradeSQLRecorder._execute(() -> super.execute(sql, autoGeneratedKeys), sql);
            }

            @Override
            public boolean execute(String sql, int[] columnIndexes) throws SQLException {
                return UpgradeSQLRecorder._execute(() -> super.execute(sql, columnIndexes), sql);
            }

            @Override
            public boolean execute(String sql, String[] columnNames) throws SQLException {
                return UpgradeSQLRecorder._execute(() -> super.execute(sql, columnNames), sql);
            }

            @Override
            public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
                return UpgradeSQLRecorder._execute(() -> super.executeUpdate(sql, autoGeneratedKeys), sql);
            }

            @Override
            public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
                return UpgradeSQLRecorder._execute(() -> super.executeUpdate(sql, columnIndexes), sql);
            }

            @Override
            public int executeUpdate(String sql, String[] columnNames) throws SQLException {
                return UpgradeSQLRecorder._execute(() -> super.executeUpdate(sql, columnNames), sql);
            }
        };
    }

    static {
        _failedSQLs = new CopyOnWriteArrayList<FailedSQL>();
        _runningSQLs = new CopyOnWriteArraySet<RunningSQL>();
        _upgradeProcessClassName = "";
    }

    @FunctionalInterface
    private static interface SQLCallable<R> {
        public R call() throws SQLException;
    }

    public static class FailedSQL {
        private final String _message;
        private final String _sql;

        public FailedSQL(String sql) {
            this("", sql);
        }

        public FailedSQL(String message, String sql) {
            this._message = message;
            this._sql = sql;
        }

        public String getMessage() {
            return this._message;
        }

        public String getSQL() {
            return this._sql;
        }

        public String toString() {
            return StringBundler.concat((String[])new String[]{"SQL: ", this._sql, "\nError: ", this._message, "\n"});
        }
    }

    public static class RunningSQL {
        private final long _duration;
        private final String _sql;
        private final String _upgradeProcessClassName;

        public RunningSQL(long duration, String sql) {
            this(duration, sql, "");
        }

        public RunningSQL(long duration, String sql, String upgradeProcessClassName) {
            this._duration = duration;
            this._sql = sql;
            this._upgradeProcessClassName = upgradeProcessClassName;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof RunningSQL)) {
                return false;
            }
            RunningSQL runningSQL = (RunningSQL)object;
            if (Validator.isBlank(this._upgradeProcessClassName)) {
                return this._sql.equals(runningSQL._sql);
            }
            return this._sql.equals(runningSQL._sql) && this._upgradeProcessClassName.equals(runningSQL._upgradeProcessClassName);
        }

        public long getDuration() {
            return this._duration;
        }

        public String getSQL() {
            return this._sql;
        }

        public String getUpgradeProcessClassName() {
            return this._upgradeProcessClassName;
        }

        public int hashCode() {
            if (Validator.isBlank(this._upgradeProcessClassName)) {
                return this._sql.hashCode();
            }
            int hashCode = HashUtil.hash((int)0, (Object)this._sql);
            return HashUtil.hash((int)hashCode, (Object)this._upgradeProcessClassName);
        }

        public String toString() {
            return StringBundler.concat((Object[])new Object[]{"Upgrade Process: ", this._upgradeProcessClassName, "\nSQL: ", this._sql, "\nDuration: ", this._duration, " ms\n"});
        }
    }
}

