/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade.util;

import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.version.Version;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpgradeProcessUtil {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeProcessUtil.class);
    private static boolean _createIGImageDocumentType;
    private static final Map<Long, String> _languageIds;

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getDefaultLanguageId(long companyId) throws SQLException {
        String languageId = _languageIds.get(companyId);
        if (languageId != null) {
            return languageId;
        }
        try (Connection connection = DataAccess.getConnection();){
            String string;
            block22: {
                ResultSet resultSet;
                block20: {
                    String string2;
                    block21: {
                        DBInspector dbInspector = new DBInspector(connection);
                        String sql = "select languageId from User_ where companyId = ?";
                        PreparedStatement preparedStatement = null;
                        if (dbInspector.hasColumn("User_", "defaultUser")) {
                            preparedStatement = connection.prepareStatement(sql + " and defaultUser = ?");
                            preparedStatement.setLong(1, companyId);
                            preparedStatement.setBoolean(2, Boolean.TRUE);
                        } else {
                            preparedStatement = connection.prepareStatement(sql + " and type_ = 0");
                            preparedStatement.setLong(1, companyId);
                        }
                        resultSet = preparedStatement.executeQuery();
                        try {
                            if (!resultSet.next()) break block20;
                            languageId = resultSet.getString("languageId");
                            _languageIds.put(companyId, languageId);
                            string2 = languageId;
                            if (resultSet == null) break block21;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return string2;
                }
                string = LocaleUtil.toLanguageId(LocaleUtil.US);
                if (resultSet == null) break block22;
                resultSet.close();
            }
            return string;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return LocaleUtil.toLanguageId(LocaleUtil.US);
        }
    }

    public static List<UpgradeProcess> initUpgradeProcesses(ClassLoader classLoader, String[] upgradeProcessClassNames) {
        ArrayList<UpgradeProcess> upgradeProcesses = new ArrayList<UpgradeProcess>();
        for (String upgradeProcessClassName : upgradeProcessClassNames) {
            if (_log.isDebugEnabled()) {
                _log.debug("Initializing upgrade " + upgradeProcessClassName);
            }
            UpgradeProcess upgradeProcess = null;
            try {
                Class<?> clazz = classLoader.loadClass(upgradeProcessClassName);
                upgradeProcess = (UpgradeProcess)clazz.newInstance();
            }
            catch (Exception exception) {
                _log.error("Unable to initialize upgrade " + upgradeProcessClassName, exception);
                continue;
            }
            upgradeProcesses.add(upgradeProcess);
        }
        return upgradeProcesses;
    }

    public static boolean isCreateIGImageDocumentType() {
        return _createIGImageDocumentType;
    }

    public static boolean isRequiredSchemaVersion(Version currentSchemaVersion, Version newSchemaVersion) {
        int result = newSchemaVersion.compareTo(currentSchemaVersion);
        return result > 0 && (newSchemaVersion.getMajor() > currentSchemaVersion.getMajor() || newSchemaVersion.getMinor() > currentSchemaVersion.getMinor());
    }

    public static void setCreateIGImageDocumentType(boolean createIGImageDocumentType) {
        _createIGImageDocumentType = createIGImageDocumentType;
    }

    public static boolean upgradeProcess(int buildNumber, List<UpgradeProcess> upgradeProcesses) throws UpgradeException {
        boolean ranUpgradeProcess = false;
        for (UpgradeProcess upgradeProcess : upgradeProcesses) {
            boolean tempRanUpgradeProcess = UpgradeProcessUtil._upgradeProcess(buildNumber, upgradeProcess);
            if (!tempRanUpgradeProcess) continue;
            ranUpgradeProcess = true;
        }
        return ranUpgradeProcess;
    }

    private static boolean _upgradeProcess(int buildNumber, UpgradeProcess upgradeProcess) throws UpgradeException {
        Class<?> clazz = upgradeProcess.getClass();
        if (upgradeProcess.getThreshold() == 0 || upgradeProcess.getThreshold() > buildNumber) {
            if (_log.isDebugEnabled()) {
                _log.debug("Running upgrade " + clazz.getName());
            }
            upgradeProcess.upgrade();
            if (_log.isDebugEnabled()) {
                _log.debug("Finished upgrade " + clazz.getName());
            }
            return true;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Upgrade threshold " + upgradeProcess.getThreshold() + " will not trigger upgrade");
            _log.debug("Skipping upgrade " + clazz.getName());
        }
        return false;
    }

    static {
        _languageIds = new HashMap<Long, String>();
    }
}

