/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade.util;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.version.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public class UpgradeVersionTreeMap
extends TreeMap<Version, List<UpgradeProcess>> {
    @Override
    public List<UpgradeProcess> put(Version key, List<UpgradeProcess> upgradeProcesses) {
        this._put(key, new ArrayList<UpgradeStep>(upgradeProcesses));
        return upgradeProcesses;
    }

    @Override
    public void put(Version key, UpgradeProcess ... upgradeProcesses) {
        ArrayList<UpgradeStep> upgradeStepList = new ArrayList<UpgradeStep>();
        for (UpgradeProcess upgradeProcess : upgradeProcesses) {
            Collections.addAll(upgradeStepList, upgradeProcess.getUpgradeSteps());
        }
        this._put(key, upgradeStepList);
    }

    private void _put(Version key, List<UpgradeStep> upgradeSteps) {
        Version version = new Version(key.getMajor(), key.getMinor(), key.getMicro(), key.getQualifier());
        ArrayList<UpgradeProcess> upgradeProcesses = new ArrayList<UpgradeProcess>();
        for (UpgradeStep upgradeStep : upgradeSteps) {
            if (!(upgradeStep instanceof UpgradeProcess)) continue;
            upgradeProcesses.add((UpgradeProcess)upgradeStep);
        }
        super.put(version, upgradeProcesses);
    }
}

