/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyCentralizedThreadLocal;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import java.util.TimeZone;

public class TimeZoneThreadLocal {
    private static final CentralizedThreadLocal<TimeZone> _defaultTimeZone = new CompanyCentralizedThreadLocal<TimeZone>(TimeZoneThreadLocal.class + "._defaultTimeZone", () -> {
        User guestUser = CompanyThreadLocal.fetchGuestUser();
        if (guestUser == null) {
            return null;
        }
        return guestUser.getTimeZone();
    });
    private static final ThreadLocal<TimeZone> _themeDisplayTimeZone = new CentralizedThreadLocal(TimeZoneThreadLocal.class + "._themeDisplayTimeZone");

    public static TimeZone getDefaultTimeZone() {
        return (TimeZone)_defaultTimeZone.get();
    }

    public static TimeZone getThemeDisplayTimeZone() {
        return _themeDisplayTimeZone.get();
    }

    public static void removeDefaultTimeZone() {
        _defaultTimeZone.remove();
    }

    public static void setDefaultTimeZone(TimeZone timeZone) {
        _defaultTimeZone.set((Object)timeZone);
    }

    public static void setThemeDisplayTimeZone(TimeZone timeZone) {
        _themeDisplayTimeZone.set(timeZone);
    }
}

