/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.version;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final Pattern _versionPattern = Pattern.compile("(\\d{1,10})(\\.(\\d{1,10})(\\.(\\d{1,10})(\\.([-_\\da-zA-Z]+))?)?)?");
    private final int _major;
    private final int _micro;
    private final int _minor;
    private final String _qualifier;

    public static Version parseVersion(String version) {
        if (version == null) {
            return new Version(0, 0, 0);
        }
        if ((version = version.trim()).isEmpty()) {
            return new Version(0, 0, 0);
        }
        Matcher matcher = _versionPattern.matcher(version = version.trim());
        if (!matcher.matches()) {
            return new Version(0, 0, 0);
        }
        return new Version(GetterUtil.getInteger(matcher.group(1)), GetterUtil.getInteger(matcher.group(3)), GetterUtil.getInteger(matcher.group(5)), GetterUtil.getString(matcher.group(7)));
    }

    public Version(int major, int minor, int micro) {
        this._major = major;
        this._minor = minor;
        this._micro = micro;
        this._qualifier = "";
    }

    public Version(int major, int minor, int micro, String qualifier) {
        this._major = major;
        this._minor = minor;
        this._micro = micro;
        this._qualifier = qualifier;
    }

    @Override
    public int compareTo(Version version) {
        int result = Integer.compare(this._major, version._major);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this._minor, version._minor);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this._micro, version._micro);
        if (result != 0) {
            return result;
        }
        String qualifier = version._qualifier;
        result = this._qualifier.compareTo(qualifier);
        if (this._qualifier.equals("") || qualifier.equals("")) {
            return result * -1;
        }
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version version = (Version)object;
        return this._major == version._major && this._minor == version._minor && this._micro == version._micro && this._qualifier.equals(version._qualifier);
    }

    public int getMajor() {
        return this._major;
    }

    public int getMicro() {
        return this._micro;
    }

    public int getMinor() {
        return this._minor;
    }

    public String getQualifier() {
        return this._qualifier;
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, (int)this._major);
        hash = HashUtil.hash((int)hash, (int)this._minor);
        hash = HashUtil.hash((int)hash, (int)this._micro);
        return HashUtil.hash((int)hash, (Object)this._qualifier);
    }

    public String toString() {
        if (Objects.equals(this.getQualifier(), "")) {
            return StringBundler.concat((Object[])new Object[]{this._major, ".", this._minor, ".", this._micro});
        }
        return StringBundler.concat((Object[])new Object[]{this._major, ".", this._minor, ".", this._micro, ".", this._qualifier});
    }
}

