/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.workflow;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalServiceUtil;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseWorkflowHandler<T>
implements WorkflowHandler<T> {
    private static final boolean _ASSET_TYPE_SEARCHABLE = true;
    private static final boolean _SCOPEABLE = true;
    private static final boolean _VISIBLE = true;
    private static final Log _log = LogFactoryUtil.getLog(BaseWorkflowHandler.class);

    @Override
    public AssetRenderer<T> getAssetRenderer(long classPK) throws PortalException {
        AssetRendererFactory<long> assetRendererFactory = this.getAssetRendererFactory();
        if (assetRendererFactory != null) {
            return assetRendererFactory.getAssetRenderer(classPK, 0);
        }
        return null;
    }

    @Override
    public AssetRendererFactory<T> getAssetRendererFactory() {
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(this.getClassName());
    }

    @Override
    public String getIconCssClass() {
        AssetRendererFactory<T> assetRendererFactory = this.getAssetRendererFactory();
        if (assetRendererFactory != null) {
            return assetRendererFactory.getIconCssClass();
        }
        return "";
    }

    @Override
    public String getNotificationLink(long workflowTaskId, ServiceContext serviceContext) throws PortalException {
        try {
            HttpServletRequest httpServletRequest = serviceContext.getRequest();
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            Layout layout = themeDisplay.getLayout();
            if (!StringUtil.matches(layout.getFriendlyURL(), "/manage")) {
                layout = LayoutLocalServiceUtil.fetchLayoutByFriendlyURL(layout.getGroupId(), false, "/manage");
            }
            if (layout == null) {
                layout = LayoutLocalServiceUtil.fetchLayout(themeDisplay.getPlid());
            }
            return PortletURLBuilder.create(PortletURLFactoryUtil.create(serviceContext.getRequest(), "com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet", layout.getPlid(), "RENDER_PHASE")).setMVCPath("/edit_workflow_task.jsp").setBackURL(themeDisplay.getURLCurrent()).setParameter("workflowTaskId", String.valueOf(workflowTaskId)).setWindowState(WindowState.MAXIMIZED).buildString();
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn(exception);
            }
            return null;
        }
    }

    @Override
    public String getSummary(long classPK, PortletRequest portletRequest, PortletResponse portletResponse) {
        block3: {
            try {
                AssetRenderer<T> assetRenderer = this.getAssetRenderer(classPK);
                if (assetRenderer != null) {
                    return assetRenderer.getSummary(portletRequest, portletResponse);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(exception);
            }
        }
        return null;
    }

    @Override
    public String getTitle(long classPK, Locale locale) {
        block3: {
            try {
                AssetRenderer<T> assetRenderer = this.getAssetRenderer(classPK);
                if (assetRenderer != null) {
                    return assetRenderer.getTitle(locale);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(exception);
            }
        }
        return null;
    }

    @Override
    public PortletURL getURLEdit(long classPK, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        block3: {
            try {
                AssetRenderer<T> assetRenderer = this.getAssetRenderer(classPK);
                if (assetRenderer != null) {
                    return assetRenderer.getURLEdit(liferayPortletRequest, liferayPortletResponse);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(exception);
            }
        }
        return null;
    }

    @Override
    public PortletURL getURLViewDiffs(long classPK, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        block3: {
            try {
                AssetRenderer<T> assetRenderer = this.getAssetRenderer(classPK);
                if (assetRenderer != null) {
                    return assetRenderer.getURLViewDiffs(liferayPortletRequest, liferayPortletResponse);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(exception);
            }
        }
        return null;
    }

    @Override
    public String getURLViewInContext(long classPK, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        block3: {
            try {
                AssetRenderer<T> assetRenderer = this.getAssetRenderer(classPK);
                if (assetRenderer != null) {
                    return assetRenderer.getURLViewInContext(liferayPortletRequest, liferayPortletResponse, noSuchEntryRedirect);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(exception);
            }
        }
        return null;
    }

    @Override
    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, long classPK) throws PortalException {
        return WorkflowDefinitionLinkLocalServiceUtil.fetchWorkflowDefinitionLink(companyId, groupId, this.getClassName(), 0L, 0L);
    }

    @Override
    public boolean include(long classPK, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String template) {
        block3: {
            try {
                AssetRenderer<T> assetRenderer = this.getAssetRenderer(classPK);
                if (assetRenderer != null) {
                    return assetRenderer.include(httpServletRequest, httpServletResponse, template);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(exception);
            }
        }
        return false;
    }

    @Override
    public boolean isAssetTypeSearchable() {
        return true;
    }

    @Override
    public boolean isScopeable() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void startWorkflowInstance(long companyId, long groupId, long userId, long classPK, T model, Map<String, Serializable> workflowContext) throws PortalException {
        WorkflowInstanceLinkLocalServiceUtil.startWorkflowInstance(companyId, groupId, userId, this.getClassName(), classPK, workflowContext);
    }
}

