/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.executor;

import com.liferay.portal.kernel.util.CentralizedThreadLocal;
import com.liferay.portal.kernel.util.ThreadLocalBinder;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class CopyThreadLocalCallable<T>
implements Callable<T> {
    private final boolean _clearOnExit;
    private final Map<CentralizedThreadLocal<?>, Object> _longLivedThreadLocals;
    private final Map<CentralizedThreadLocal<?>, Object> _shortLivedlThreadLocals;
    private final ThreadLocalBinder _threadLocalBinder;

    public CopyThreadLocalCallable(boolean readOnly, boolean clearOnExit) {
        this(null, readOnly, clearOnExit);
    }

    public CopyThreadLocalCallable(ThreadLocalBinder threadLocalBinder, boolean readOnly, boolean clearOnExit) {
        this._threadLocalBinder = threadLocalBinder;
        if (this._threadLocalBinder != null) {
            this._threadLocalBinder.record();
        }
        if (readOnly) {
            this._longLivedThreadLocals = Collections.unmodifiableMap(CentralizedThreadLocal.getLongLivedThreadLocals());
            this._shortLivedlThreadLocals = Collections.unmodifiableMap(CentralizedThreadLocal.getShortLivedThreadLocals());
        } else {
            this._longLivedThreadLocals = CentralizedThreadLocal.getLongLivedThreadLocals();
            this._shortLivedlThreadLocals = CentralizedThreadLocal.getShortLivedThreadLocals();
        }
        this._clearOnExit = clearOnExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T call() throws Exception {
        CentralizedThreadLocal.setThreadLocals(this._longLivedThreadLocals, this._shortLivedlThreadLocals);
        if (this._threadLocalBinder != null) {
            this._threadLocalBinder.bind();
        }
        try {
            T t = this.doCall();
            return t;
        }
        finally {
            if (this._clearOnExit) {
                if (this._threadLocalBinder != null) {
                    this._threadLocalBinder.cleanUp();
                }
                CentralizedThreadLocal.clearLongLivedThreadLocals();
                CentralizedThreadLocal.clearShortLivedThreadLocals();
            }
        }
    }

    public abstract T doCall() throws Exception;
}

