/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.module.configuration;

import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletInstance;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerList;

public class ConfigurationProviderUtil {
    private static final ServiceTrackerList<ConfigurationProvider> _configurationProvider = ServiceTrackerCollections.openList(ConfigurationProvider.class);

    public static <T> T getCompanyConfiguration(Class<T> clazz, long companyId) throws ConfigurationException {
        ConfigurationProvider configurationProvider = ConfigurationProviderUtil.getConfigurationProvider();
        return configurationProvider.getCompanyConfiguration(clazz, companyId);
    }

    public static <T> T getConfiguration(Class<T> clazz, SettingsLocator settingsLocator) throws ConfigurationException {
        ConfigurationProvider configurationProvider = ConfigurationProviderUtil.getConfigurationProvider();
        return configurationProvider.getConfiguration(clazz, settingsLocator);
    }

    public static ConfigurationProvider getConfigurationProvider() {
        PortalRuntimePermission.checkGetBeanProperty(ConfigurationProviderUtil.class);
        return (ConfigurationProvider)_configurationProvider.get(0);
    }

    public static <T> T getGroupConfiguration(Class<T> clazz, long groupId) throws ConfigurationException {
        ConfigurationProvider configurationProvider = ConfigurationProviderUtil.getConfigurationProvider();
        return configurationProvider.getGroupConfiguration(clazz, groupId);
    }

    public static <T> T getPortletInstanceConfiguration(Class<T> clazz, Layout layout, PortletInstance portletInstance) throws ConfigurationException {
        ConfigurationProvider configurationProvider = ConfigurationProviderUtil.getConfigurationProvider();
        return configurationProvider.getPortletInstanceConfiguration(clazz, layout, portletInstance);
    }
}

