/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.rpc;

import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.nio.intraband.CompletionHandler;
import com.liferay.portal.kernel.nio.intraband.Datagram;
import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.SystemDataType;
import com.liferay.portal.kernel.nio.intraband.rpc.RPCResponse;
import com.liferay.portal.kernel.process.ProcessCallable;
import java.io.IOException;
import java.io.Serializable;
import java.util.EnumSet;

public class IntrabandRPCUtil {
    protected static EnumSet<CompletionHandler.CompletionType> repliedEnumSet = EnumSet.of(CompletionHandler.CompletionType.REPLIED);

    public static <V extends Serializable> NoticeableFuture<V> execute(RegistrationReference registrationReference, ProcessCallable<V> processCallable) {
        Intraband intraband = registrationReference.getIntraband();
        SystemDataType systemDataType = SystemDataType.RPC;
        Serializer serializer = new Serializer();
        serializer.writeObject(processCallable);
        Datagram datagram = Datagram.createRequestDatagram(systemDataType.getValue(), serializer.toByteBuffer());
        DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
        intraband.sendDatagram(registrationReference, datagram, null, repliedEnumSet, new FutureCompletionHandler(defaultNoticeableFuture));
        return defaultNoticeableFuture;
    }

    protected static class FutureCompletionHandler<V extends Serializable>
    implements CompletionHandler<Object> {
        private final DefaultNoticeableFuture<V> _defaultNoticeableFuture;

        @Override
        public void delivered(Object attachment) {
        }

        @Override
        public void failed(Object attachment, IOException ioe) {
            this._defaultNoticeableFuture.setException(ioe);
        }

        @Override
        public void replied(Object attachment, Datagram datagram) {
            Deserializer deserializer = new Deserializer(datagram.getDataByteBuffer());
            try {
                RPCResponse rpcResponse = (RPCResponse)deserializer.readObject();
                Exception exception = rpcResponse.getException();
                if (exception != null) {
                    this._defaultNoticeableFuture.setException(exception);
                } else {
                    this._defaultNoticeableFuture.set((V)rpcResponse.getResult());
                }
            }
            catch (ClassNotFoundException cnfe) {
                this._defaultNoticeableFuture.setException(cnfe);
            }
        }

        @Override
        public void submitted(Object attachment) {
        }

        @Override
        public void timedOut(Object attachment) {
            this._defaultNoticeableFuture.cancel(true);
        }

        protected FutureCompletionHandler(DefaultNoticeableFuture<V> defaultNoticeableFuture) {
            this._defaultNoticeableFuture = defaultNoticeableFuture;
        }
    }
}

