/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.kernel.lar;

import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LongWrapper;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ManifestSummary
implements Serializable {
    private Map<String, String[]> _configurationPortletOptions = new HashMap<String, String[]>();
    private List<Portlet> _dataPortlets = new ArrayList<Portlet>();
    private Date _exportDate;
    private List<Portlet> _layoutPortlets = new ArrayList<Portlet>();
    private Set<String> _manifestSummaryKeys = new HashSet<String>();
    private Map<String, LongWrapper> _modelAdditionCounters = new HashMap<String, LongWrapper>();
    private Map<String, LongWrapper> _modelDeletionCounters = new HashMap<String, LongWrapper>();

    public static String getManifestSummaryKey(StagedModelType stagedModelType) {
        return ManifestSummary.getManifestSummaryKey(stagedModelType.getClassName(), stagedModelType.getReferrerClassName());
    }

    public void addDataPortlet(Portlet portlet, String[] configurationPortletOptions) {
        String rootPortletId = portlet.getRootPortletId();
        if (!this._configurationPortletOptions.containsKey(rootPortletId)) {
            this._dataPortlets.add(portlet);
            this._configurationPortletOptions.put(rootPortletId, configurationPortletOptions);
        }
    }

    public void addLayoutPortlet(Portlet portlet, String[] configurationPortletOptions) {
        String rootPortletId = portlet.getRootPortletId();
        if (!this._configurationPortletOptions.containsKey(rootPortletId)) {
            this._layoutPortlets.add(portlet);
            this._configurationPortletOptions.put(rootPortletId, configurationPortletOptions);
        }
    }

    public void addModelAdditionCount(StagedModelType stagedModelType, long count) {
        this.addModelAdditionCount(ManifestSummary.getManifestSummaryKey(stagedModelType), count);
    }

    public void addModelAdditionCount(String manifestSummaryKey, long count) {
        LongWrapper modelAdditionCounter = this._modelAdditionCounters.get(manifestSummaryKey);
        if (modelAdditionCounter == null) {
            modelAdditionCounter = new LongWrapper();
            this._modelAdditionCounters.put(manifestSummaryKey, modelAdditionCounter);
        }
        modelAdditionCounter.setValue(count);
        this._manifestSummaryKeys.add(manifestSummaryKey);
    }

    public void addModelDeletionCount(StagedModelType stagedModelType, long count) {
        this.addModelDeletionCount(ManifestSummary.getManifestSummaryKey(stagedModelType), count);
    }

    public void addModelDeletionCount(String manifestSummaryKey, long count) {
        LongWrapper modelDeletionCounter = this._modelDeletionCounters.get(manifestSummaryKey);
        if (modelDeletionCounter == null) {
            modelDeletionCounter = new LongWrapper();
            this._modelDeletionCounters.put(manifestSummaryKey, modelDeletionCounter);
        }
        modelDeletionCounter.setValue(count);
        this._manifestSummaryKeys.add(manifestSummaryKey);
    }

    public Object clone() {
        ManifestSummary manifestSummary = new ManifestSummary();
        manifestSummary._configurationPortletOptions = new HashMap<String, String[]>(manifestSummary._configurationPortletOptions);
        manifestSummary._dataPortlets = new ArrayList<Portlet>(this._dataPortlets);
        manifestSummary._layoutPortlets = new ArrayList<Portlet>(this._layoutPortlets);
        if (this._exportDate != null) {
            manifestSummary.setExportDate(new Date(this._exportDate.getTime()));
        }
        manifestSummary._manifestSummaryKeys = new HashSet<String>(this._manifestSummaryKeys);
        manifestSummary._modelAdditionCounters = new HashMap<String, LongWrapper>(this._modelAdditionCounters);
        manifestSummary._modelDeletionCounters = new HashMap<String, LongWrapper>(this._modelDeletionCounters);
        return manifestSummary;
    }

    public long getAllModelDeletionCounts() {
        long modelDeletionCount = -1L;
        for (String manifestSummaryKey : this._manifestSummaryKeys) {
            long manifestSummaryKeyModelDeletionCount = this.getModelDeletionCount(manifestSummaryKey);
            if (manifestSummaryKeyModelDeletionCount == -1L) continue;
            if (modelDeletionCount == -1L) {
                modelDeletionCount = manifestSummaryKeyModelDeletionCount;
                continue;
            }
            modelDeletionCount += manifestSummaryKeyModelDeletionCount;
        }
        return modelDeletionCount;
    }

    public String[] getConfigurationPortletOptions(String rootPortletId) {
        return this._configurationPortletOptions.get(rootPortletId);
    }

    public List<Portlet> getDataPortlets() {
        return this._dataPortlets;
    }

    public Date getExportDate() {
        return this._exportDate;
    }

    public List<Portlet> getLayoutPortlets() {
        return this._layoutPortlets;
    }

    public Collection<String> getManifestSummaryKeys() {
        return this._manifestSummaryKeys;
    }

    @Deprecated
    public long getModelAdditionCount(Class<? extends ClassedModel> clazz) {
        return this.getModelAdditionCount(new StagedModelType(clazz));
    }

    @Deprecated
    public long getModelAdditionCount(Class<? extends ClassedModel> clazz, Class<? extends ClassedModel> referrerClass) {
        return this.getModelAdditionCount(clazz.getName(), referrerClass.getName());
    }

    public long getModelAdditionCount(StagedModel stagedModel) {
        return this.getModelAdditionCount(stagedModel.getStagedModelType());
    }

    public long getModelAdditionCount(StagedModelType stagedModelType) {
        return this.getModelAdditionCount(stagedModelType.getClassName(), stagedModelType.getReferrerClassName());
    }

    public long getModelAdditionCount(String manifestSummaryKey) {
        if (!this._modelAdditionCounters.containsKey(manifestSummaryKey)) {
            return -1L;
        }
        LongWrapper modelAdditionCounter = this._modelAdditionCounters.get(manifestSummaryKey);
        return modelAdditionCounter.getValue();
    }

    public Map<String, LongWrapper> getModelAdditionCounters() {
        return this._modelAdditionCounters;
    }

    @Deprecated
    public long getModelDeletionCount() {
        return this.getAllModelDeletionCounts();
    }

    @Deprecated
    public long getModelDeletionCount(Class<? extends ClassedModel> clazz) {
        return this.getModelDeletionCount(new StagedModelType(clazz));
    }

    public long getModelDeletionCount(StagedModel stagedModel) {
        return this.getModelDeletionCount(stagedModel.getStagedModelType());
    }

    public long getModelDeletionCount(StagedModelType stagedModelType) {
        return this.getModelDeletionCount(stagedModelType.getClassName(), stagedModelType.getReferrerClassName());
    }

    public long getModelDeletionCount(StagedModelType[] stagedModelTypes) {
        if (ArrayUtil.isEmpty(stagedModelTypes)) {
            return 0L;
        }
        long modelDeletionCount = -1L;
        for (StagedModelType stagedModelType : stagedModelTypes) {
            long stagedModelTypeModelDeletionCount = this.getModelDeletionCount(stagedModelType);
            if (stagedModelTypeModelDeletionCount == -1L) continue;
            if (modelDeletionCount == -1L) {
                modelDeletionCount = stagedModelTypeModelDeletionCount;
                continue;
            }
            modelDeletionCount += stagedModelTypeModelDeletionCount;
        }
        return modelDeletionCount;
    }

    public long getModelDeletionCount(String manifestSummaryKey) {
        if (!this._modelDeletionCounters.containsKey(manifestSummaryKey)) {
            return -1L;
        }
        LongWrapper modelDeletionCounter = this._modelDeletionCounters.get(manifestSummaryKey);
        return modelDeletionCounter.getValue();
    }

    public Map<String, LongWrapper> getModelDeletionCounters() {
        return this._modelDeletionCounters;
    }

    public void incrementModelAdditionCount(StagedModelType stagedModelType) {
        String manifestSummaryKey = ManifestSummary.getManifestSummaryKey(stagedModelType);
        if (!this._modelAdditionCounters.containsKey(manifestSummaryKey)) {
            this._modelAdditionCounters.put(manifestSummaryKey, new LongWrapper(1L));
            this._manifestSummaryKeys.add(manifestSummaryKey);
            return;
        }
        LongWrapper modelAdditionCounter = this._modelAdditionCounters.get(manifestSummaryKey);
        modelAdditionCounter.increment();
    }

    public void incrementModelDeletionCount(StagedModelType stagedModelType) {
        String manifestSummaryKey = ManifestSummary.getManifestSummaryKey(stagedModelType);
        if (!this._modelDeletionCounters.containsKey(manifestSummaryKey)) {
            this._modelDeletionCounters.put(manifestSummaryKey, new LongWrapper(1L));
            this._manifestSummaryKeys.add(manifestSummaryKey);
            return;
        }
        LongWrapper modelDeletionCounter = this._modelDeletionCounters.get(manifestSummaryKey);
        modelDeletionCounter.increment();
    }

    public void resetCounters() {
        this._modelAdditionCounters.clear();
        this._modelDeletionCounters.clear();
        this._manifestSummaryKeys.clear();
    }

    public void setExportDate(Date exportDate) {
        this._exportDate = exportDate;
    }

    public String toString() {
        StringBundler sb = new StringBundler(5);
        sb.append("{modelAdditionCounters=");
        sb.append(MapUtil.toString(this._modelAdditionCounters));
        sb.append(", modelDeletionCounters=");
        sb.append(MapUtil.toString(this._modelDeletionCounters));
        sb.append("}");
        return sb.toString();
    }

    protected static String getManifestSummaryKey(String modelName, String referrerModelName) {
        if (Validator.isNull(referrerModelName)) {
            return modelName;
        }
        return modelName.concat("#").concat(referrerModelName);
    }

    protected long getModelAdditionCount(String className, String referrerClassName) {
        if (Validator.isNull(referrerClassName) || !referrerClassName.equals("referrer-class-name-all") && !referrerClassName.equals("referrer-class-name-any")) {
            String manifestSummaryKey = ManifestSummary.getManifestSummaryKey(className, referrerClassName);
            return this.getModelAdditionCount(manifestSummaryKey);
        }
        long modelAdditionCount = -1L;
        for (String key : this._modelAdditionCounters.keySet()) {
            long count;
            if (!key.startsWith(className.concat("#")) && (!key.equals(className) || !referrerClassName.equals("referrer-class-name-all")) || (count = this.getModelAdditionCount(key)) < 0L) continue;
            if (modelAdditionCount < 0L) {
                modelAdditionCount = count;
                continue;
            }
            modelAdditionCount += count;
        }
        return modelAdditionCount;
    }

    protected long getModelDeletionCount(String className, String referrerClassName) {
        if (Validator.isNull(referrerClassName) || !referrerClassName.equals("referrer-class-name-all") && !referrerClassName.equals("referrer-class-name-any")) {
            String manifestSummaryKey = ManifestSummary.getManifestSummaryKey(className, referrerClassName);
            return this.getModelDeletionCount(manifestSummaryKey);
        }
        long modelDeletionCount = -1L;
        for (String key : this._modelDeletionCounters.keySet()) {
            long count;
            if (!key.startsWith(className.concat("#")) && (!key.equals(className) || !referrerClassName.equals("referrer-class-name-all")) || (count = this.getModelDeletionCount(key)) < 0L) continue;
            if (modelDeletionCount < 0L) {
                modelDeletionCount = count;
                continue;
            }
            modelDeletionCount += count;
        }
        return modelDeletionCount;
    }
}

