/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.search;

import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.ResultRow;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.RowMover;
import com.liferay.portal.kernel.dao.search.SearchPaginationUtil;
import com.liferay.portal.kernel.util.DeterminateKeyGenerator;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class SearchContainer<R> {
    public static final int DEFAULT_CUR = 1;
    public static final String DEFAULT_CUR_PARAM = "cur";
    public static final int DEFAULT_DELTA = GetterUtil.getInteger(PropsUtil.get("search.container.page.default.delta"));
    public static final boolean DEFAULT_DELTA_CONFIGURABLE = true;
    public static final String DEFAULT_DELTA_PARAM = "delta";
    public static final String DEFAULT_DEPRECATED_TOTAL_VAR = "deprecatedTotal";
    public static final boolean DEFAULT_FORCE_POST = false;
    public static final String DEFAULT_ORDER_BY_COL_PARAM = "orderByCol";
    public static final String DEFAULT_ORDER_BY_TYPE_PARAM = "orderByType";
    public static final String DEFAULT_RESULTS_VAR = "results";
    public static final String DEFAULT_TOTAL_VAR = "total";
    public static final String DEFAULT_VAR = "searchContainer";
    public static final int MAX_DELTA = 200;
    private String _className;
    private String _cssClass = "";
    private int _cur;
    private final String _curParam;
    private int _delta = DEFAULT_DELTA;
    private boolean _deltaConfigurable = true;
    private String _deltaParam = "delta";
    private final DisplayTerms _displayTerms;
    private String _emptyResultsMessage;
    private String _emptyResultsMessageCssClass;
    private int _end;
    private boolean _forcePost = false;
    private List<String> _headerNames;
    private boolean _hover = true;
    private String _id;
    private PortletURL _iteratorURL;
    private List<String> _normalizedHeaderNames;
    private Map<String, String> _orderableHeaders;
    private String _orderByCol;
    private String _orderByColParam = "orderByCol";
    private OrderByComparator<R> _orderByComparator;
    private String _orderByJS;
    private String _orderByType;
    private String _orderByTypeParam = "orderByType";
    private final PortletRequest _portletRequest;
    private int _resultEnd;
    private final List<ResultRow> _resultRows = new ArrayList<ResultRow>();
    private List<R> _results = new ArrayList<R>();
    private RowChecker _rowChecker;
    private RowMover _rowMover;
    private boolean _search;
    private final DisplayTerms _searchTerms;
    private int _start;
    private String _summary;
    private int _total;
    private String _totalVar;
    private boolean _uniqueId;

    public SearchContainer() {
        this._curParam = DEFAULT_CUR_PARAM;
        this._displayTerms = null;
        this._portletRequest = null;
        this._searchTerms = null;
    }

    public SearchContainer(PortletRequest portletRequest, DisplayTerms displayTerms, DisplayTerms searchTerms, String curParam, int cur, int delta, PortletURL iteratorURL, List<String> headerNames, String emptyResultsMessage) {
        this(portletRequest, displayTerms, searchTerms, curParam, cur, delta, iteratorURL, headerNames, emptyResultsMessage, "");
    }

    public SearchContainer(PortletRequest portletRequest, DisplayTerms displayTerms, DisplayTerms searchTerms, String curParam, int cur, int delta, PortletURL iteratorURL, List<String> headerNames, String emptyResultsMessage, String cssClass) {
        String keywords;
        this._portletRequest = portletRequest;
        this._displayTerms = displayTerms;
        this._searchTerms = searchTerms;
        this._curParam = curParam;
        boolean resetCur = ParamUtil.getBoolean(portletRequest, "resetCur");
        if (resetCur) {
            this._cur = 1;
        } else if (cur < 1) {
            this._cur = ParamUtil.getInteger(portletRequest, this._curParam, 1);
            if (this._cur < 1) {
                this._cur = 1;
            }
        } else {
            this._cur = cur;
        }
        if (!this._curParam.equals(DEFAULT_CUR_PARAM)) {
            this._deltaParam = DEFAULT_DELTA_PARAM + StringUtil.replace(this._curParam, DEFAULT_CUR_PARAM, "");
        }
        this.setDelta(ParamUtil.getInteger(portletRequest, this._deltaParam, delta));
        this._iteratorURL = iteratorURL;
        this._iteratorURL.setParameter(this._curParam, String.valueOf(this._cur));
        this._iteratorURL.setParameter(this._deltaParam, String.valueOf(this._delta));
        this._setParameter("keywords");
        this._setParameter("advancedSearch");
        this._setParameter("andOperator");
        if (headerNames != null) {
            this._headerNames = new ArrayList<String>(headerNames.size());
            this._headerNames.addAll(headerNames);
            this._buildNormalizedHeaderNames(this._headerNames);
        }
        this._emptyResultsMessage = emptyResultsMessage;
        if (Validator.isNotNull(cssClass)) {
            this._cssClass = cssClass;
        }
        if (Validator.isNotNull(keywords = ParamUtil.getString(portletRequest, "keywords"))) {
            this._search = true;
        }
    }

    public SearchContainer(PortletRequest portletRequest, DisplayTerms displayTerms, DisplayTerms searchTerms, String curParam, int delta, PortletURL iteratorURL, List<String> headerNames, String emptyResultsMessage) {
        this(portletRequest, displayTerms, searchTerms, curParam, 0, delta, iteratorURL, headerNames, emptyResultsMessage);
    }

    public SearchContainer(PortletRequest portletRequest, PortletURL iteratorURL, List<String> headerNames, String emptyResultsMessage) {
        this(portletRequest, null, null, DEFAULT_CUR_PARAM, DEFAULT_DELTA, iteratorURL, headerNames, emptyResultsMessage);
    }

    public String getClassName() {
        return this._className;
    }

    public String getCssClass() {
        return this._cssClass;
    }

    public int getCur() {
        return this._cur;
    }

    public String getCurParam() {
        return this._curParam;
    }

    public int getDelta() {
        return this._delta;
    }

    public String getDeltaParam() {
        return this._deltaParam;
    }

    public DisplayTerms getDisplayTerms() {
        return this._displayTerms;
    }

    public String getEmptyResultsMessage() {
        return this._emptyResultsMessage;
    }

    public String getEmptyResultsMessageCssClass() {
        return this._emptyResultsMessageCssClass;
    }

    public int getEnd() {
        return this._end;
    }

    public List<String> getHeaderNames() {
        return this._headerNames;
    }

    public String getId(HttpServletRequest request, String namespace) {
        if (this._uniqueId) {
            return this._id;
        }
        if (Validator.isNotNull(this._id)) {
            this._id = PortalUtil.getUniqueElementId(request, namespace, this._id);
            this._uniqueId = true;
            return this._id;
        }
        String id = null;
        if (Validator.isNotNull(this._className)) {
            String simpleClassName = this._className;
            int pos = simpleClassName.lastIndexOf(".");
            if (pos != -1) {
                simpleClassName = simpleClassName.substring(pos + 1);
            }
            String variableCasingSimpleClassName = TextFormatter.format(simpleClassName, 8);
            id = TextFormatter.formatPlural(variableCasingSimpleClassName);
            id = id.concat("SearchContainer");
            this._id = PortalUtil.getUniqueElementId(request, namespace, id);
            this._uniqueId = true;
            return this._id;
        }
        id = DeterminateKeyGenerator.generate("taglib_search_container");
        this._id = id.concat("SearchContainer");
        this._uniqueId = true;
        return this._id;
    }

    public PortletURL getIteratorURL() {
        return this._iteratorURL;
    }

    public List<String> getNormalizedHeaderNames() {
        return this._normalizedHeaderNames;
    }

    public Map<String, String> getOrderableHeaders() {
        return this._orderableHeaders;
    }

    public String getOrderByCol() {
        return this._orderByCol;
    }

    public String getOrderByColParam() {
        return this._orderByColParam;
    }

    public OrderByComparator<R> getOrderByComparator() {
        return this._orderByComparator;
    }

    public String getOrderByJS() {
        return this._orderByJS;
    }

    public String getOrderByType() {
        return this._orderByType;
    }

    public String getOrderByTypeParam() {
        return this._orderByTypeParam;
    }

    public PortletRequest getPortletRequest() {
        return this._portletRequest;
    }

    public int getResultEnd() {
        return this._resultEnd;
    }

    public List<ResultRow> getResultRows() {
        return this._resultRows;
    }

    public List<R> getResults() {
        return this._results;
    }

    public RowChecker getRowChecker() {
        return this._rowChecker;
    }

    public RowMover getRowMover() {
        return this._rowMover;
    }

    public DisplayTerms getSearchTerms() {
        return this._searchTerms;
    }

    public int getStart() {
        return this._start;
    }

    public String getSummary() {
        return this._summary;
    }

    public int getTotal() {
        return this._total;
    }

    public String getTotalVar() {
        return this._totalVar;
    }

    public boolean hasResults() {
        return !this._results.isEmpty();
    }

    public boolean isDeltaConfigurable() {
        return this._deltaConfigurable;
    }

    public boolean isForcePost() {
        return this._forcePost;
    }

    public boolean isHover() {
        return this._hover;
    }

    public boolean isRecalculateCur() {
        if (this._total == 0 && this._cur == 1) {
            return false;
        }
        return (this._cur - 1) * this._delta >= this._total;
    }

    public boolean isSearch() {
        return this._search;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setCssClass(String cssClass) {
        this._cssClass = cssClass;
    }

    public void setDelta(int delta) {
        this._delta = delta <= 0 ? DEFAULT_DELTA : (delta > 200 ? 200 : delta);
        this._calculateStartAndEnd();
    }

    public void setDeltaConfigurable(boolean deltaConfigurable) {
        this._deltaConfigurable = deltaConfigurable;
    }

    public void setDeltaParam(String deltaParam) {
        this._deltaParam = deltaParam;
    }

    public void setEmptyResultsMessage(String emptyResultsMessage) {
        this._emptyResultsMessage = emptyResultsMessage;
    }

    public void setEmptyResultsMessageCssClass(String emptyResultsMessageCssClass) {
        this._emptyResultsMessageCssClass = emptyResultsMessageCssClass;
    }

    public void setForcePost(boolean forcePost) {
        this._forcePost = forcePost;
    }

    public void setHeaderNames(List<String> headerNames) {
        this._headerNames = headerNames;
        this._buildNormalizedHeaderNames(headerNames);
    }

    public void setHover(boolean hover) {
        this._hover = hover;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setIteratorURL(PortletURL iteratorURL) {
        this._iteratorURL = iteratorURL;
    }

    public void setOrderableHeaders(Map<String, String> orderableHeaders) {
        this._orderableHeaders = orderableHeaders;
    }

    public void setOrderByCol(String orderByCol) {
        this._orderByCol = orderByCol;
        this._iteratorURL.setParameter(this._orderByColParam, this._orderByCol);
    }

    public void setOrderByColParam(String orderByColParam) {
        this._orderByColParam = orderByColParam;
    }

    public void setOrderByComparator(OrderByComparator<R> orderByComparator) {
        this._orderByComparator = orderByComparator;
    }

    public void setOrderByJS(String orderByJS) {
        this._orderByJS = orderByJS;
    }

    public void setOrderByType(String orderByType) {
        this._orderByType = orderByType;
        this._iteratorURL.setParameter(this._orderByTypeParam, this._orderByType);
    }

    public void setOrderByTypeParam(String orderByTypeParam) {
        this._orderByTypeParam = orderByTypeParam;
    }

    public void setResults(List<R> results) {
        this._results = results;
    }

    public void setRowChecker(RowChecker rowChecker) {
        this._rowChecker = rowChecker;
    }

    public void setRowMover(RowMover rowMover) {
        this._rowMover = rowMover;
    }

    public void setSearch(boolean search) {
        this._search = search;
    }

    public void setSummary(String summary) {
        this._summary = summary;
    }

    public void setTotal(int total) {
        this._total = total;
        this._calculateCur();
        this._calculateStartAndEnd();
    }

    public void setTotalVar(String totalVar) {
        this._totalVar = totalVar;
    }

    private void _buildNormalizedHeaderNames(List<String> headerNames) {
        if (headerNames == null) {
            return;
        }
        this._normalizedHeaderNames = new ArrayList<String>(headerNames.size());
        for (String headerName : headerNames) {
            this._normalizedHeaderNames.add(FriendlyURLNormalizerUtil.normalize(headerName));
        }
    }

    private void _calculateCur() {
        if (this._total == 0) {
            this._cur = 1;
            return;
        }
        if (this.isRecalculateCur()) {
            this._cur = this._total % this._delta == 0 ? this._total / this._delta : this._total / this._delta + 1;
        }
    }

    private void _calculateStartAndEnd() {
        int[] startAndEnd = SearchPaginationUtil.calculateStartAndEnd(this._cur, this._delta);
        this._start = startAndEnd[0];
        this._resultEnd = this._end = startAndEnd[1];
        if (this._resultEnd > this._total) {
            this._resultEnd = this._total;
        }
    }

    private void _setParameter(String name) {
        String value = this._portletRequest.getParameter(name);
        if (value != null) {
            this._iteratorURL.setParameter(name, value);
        }
    }
}

