/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.proxy;

import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.proxy.BaseProxyBean;
import com.liferay.portal.kernel.messaging.proxy.MessageValuesThreadLocal;
import com.liferay.portal.kernel.messaging.proxy.ProxyRequest;
import com.liferay.portal.kernel.messaging.proxy.ProxyResponse;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import com.liferay.portal.kernel.util.ServiceProxyFactory;

public abstract class BaseMultiDestinationProxyBean {
    private static volatile SynchronousMessageSender _defaultSynchronousMessageSender = ServiceProxyFactory.newServiceTrackedInstance(SynchronousMessageSender.class, BaseProxyBean.class, "_defaultSynchronousMessageSender", "(mode=DEFAULT)", true);
    private static volatile SynchronousMessageSender _directSynchronousMessageSender = ServiceProxyFactory.newServiceTrackedInstance(SynchronousMessageSender.class, BaseProxyBean.class, "_directSynchronousMessageSender", "(mode=DIRECT)", true);
    private SynchronousMessageSender.Mode _mode;

    public void afterPropertiesSet() {
    }

    public abstract String getDestinationName(ProxyRequest var1);

    public void send(ProxyRequest proxyRequest) {
        MessageBusUtil.sendMessage(this.getDestinationName(proxyRequest), this.buildMessage(proxyRequest));
    }

    @Deprecated
    public void setMessageBus(MessageBus messageBus) {
    }

    @Deprecated
    public void setSynchronousMessageSender(SynchronousMessageSender synchronousMessageSender) {
    }

    public void setSynchronousMessageSenderMode(SynchronousMessageSender.Mode mode) {
        this._mode = mode;
    }

    public Object synchronousSend(ProxyRequest proxyRequest) throws Exception {
        Message message = new Message();
        message.setPayload(proxyRequest);
        SynchronousMessageSender synchronousMessageSender = this._getSynchronousMessageSender();
        ProxyResponse proxyResponse = (ProxyResponse)synchronousMessageSender.send(this.getDestinationName(proxyRequest), message);
        if (proxyResponse == null) {
            return proxyRequest.execute(this);
        }
        if (proxyResponse.hasError()) {
            throw proxyResponse.getException();
        }
        return proxyResponse.getResult();
    }

    protected Message buildMessage(ProxyRequest proxyRequest) {
        Message message = new Message();
        message.setPayload(proxyRequest);
        MessageValuesThreadLocal.populateMessageFromThreadLocals(message);
        return message;
    }

    private SynchronousMessageSender _getSynchronousMessageSender() {
        if (this._mode == SynchronousMessageSender.Mode.DEFAULT) {
            return _defaultSynchronousMessageSender;
        }
        return _directSynchronousMessageSender;
    }
}

