/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.proxy;

import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.proxy.MessageValuesThreadLocal;
import com.liferay.portal.kernel.messaging.proxy.ProxyRequest;
import com.liferay.portal.kernel.messaging.proxy.ProxyResponse;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSender;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationSynchronousMessageSender;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import com.liferay.portal.kernel.util.ServiceProxyFactory;

public abstract class BaseProxyBean {
    private static volatile SynchronousMessageSender _defaultSynchronousMessageSender = ServiceProxyFactory.newServiceTrackedInstance(SynchronousMessageSender.class, BaseProxyBean.class, "_defaultSynchronousMessageSender", "(mode=DEFAULT)", true);
    private static volatile SynchronousMessageSender _directSynchronousMessageSender = ServiceProxyFactory.newServiceTrackedInstance(SynchronousMessageSender.class, BaseProxyBean.class, "_directSynchronousMessageSender", "(mode=DIRECT)", true);
    private static volatile MessageBus _messageBus = ServiceProxyFactory.newServiceTrackedInstance(MessageBus.class, BaseProxyBean.class, "_messageBus", true);
    private String _destinationName;
    private String _synchronousDestinationName;
    private SynchronousMessageSender.Mode _synchronousMessageSenderMode;

    @Deprecated
    public void afterPropertiesSet() {
    }

    public void send(ProxyRequest proxyRequest) {
        _messageBus.sendMessage(this._destinationName, this.buildMessage(proxyRequest));
    }

    public void setDestinationName(String destinationName) {
        this._destinationName = destinationName;
    }

    @Deprecated
    public void setSingleDestinationMessageSender(SingleDestinationMessageSender singleDestinationMessageSender) {
    }

    @Deprecated
    public void setSingleDestinationSynchronousMessageSender(SingleDestinationSynchronousMessageSender singleDestinationSynchronousMessageSender) {
    }

    public void setSynchronousDestinationName(String synchronousDestinationName) {
        this._synchronousDestinationName = synchronousDestinationName;
    }

    public void setSynchronousMessageSenderMode(SynchronousMessageSender.Mode synchronousMessageSenderMode) {
        this._synchronousMessageSenderMode = synchronousMessageSenderMode;
    }

    public Object synchronousSend(ProxyRequest proxyRequest) throws Exception {
        if (!MessageBusUtil.hasMessageListener(this._destinationName)) {
            return proxyRequest.execute(this);
        }
        SynchronousMessageSender synchronousMessageSender = this._getSynchronousMessageSender();
        ProxyResponse proxyResponse = (ProxyResponse)synchronousMessageSender.send(this._synchronousDestinationName, this.buildMessage(proxyRequest));
        if (proxyResponse == null) {
            return proxyRequest.execute(this);
        }
        if (proxyResponse.hasError()) {
            throw proxyResponse.getException();
        }
        return proxyResponse.getResult();
    }

    protected Message buildMessage(ProxyRequest proxyRequest) {
        Message message = new Message();
        message.setPayload(proxyRequest);
        MessageValuesThreadLocal.populateMessageFromThreadLocals(message);
        if (proxyRequest.isLocal()) {
            message.put("LOCAL_MESSAGE", Boolean.TRUE);
        }
        return message;
    }

    private SynchronousMessageSender _getSynchronousMessageSender() {
        if (this._synchronousMessageSenderMode == SynchronousMessageSender.Mode.DEFAULT) {
            return _defaultSynchronousMessageSender;
        }
        return _directSynchronousMessageSender;
    }
}

