/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.servlet.ServletContextClassLoaderPool;
import javax.servlet.ServletContext;

public class PortletClassLoaderUtil {
    private static final ThreadLocal<String> _servletContextName = new CentralizedThreadLocal(PortletClassLoaderUtil.class + "._servletContextName");

    public static ClassLoader getClassLoader() {
        String servletContextName = PortletClassLoaderUtil.getServletContextName();
        ClassLoader classLoader = ServletContextClassLoaderPool.getClassLoader(servletContextName);
        if (classLoader == null) {
            throw new IllegalStateException("Unable to find the class loader for servlet context " + servletContextName);
        }
        return classLoader;
    }

    @Deprecated
    public static ClassLoader getClassLoader(String portletId) {
        PortletBag portletBag = PortletBagPool.get(portletId);
        if (portletBag == null) {
            return null;
        }
        ServletContext servletContext = portletBag.getServletContext();
        return servletContext.getClassLoader();
    }

    public static String getServletContextName() {
        String servletContextName = _servletContextName.get();
        if (servletContextName == null) {
            throw new IllegalStateException("No servlet context name specified");
        }
        return servletContextName;
    }

    public static void setServletContextName(String servletContextName) {
        _servletContextName.set(servletContextName);
    }
}

