/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletJSONUtil {
    public static void populatePortletJSONObject(HttpServletRequest request, String portletHTML, Portlet portlet, JSONObject jsonObject) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashSet<String> footerCssSet = new LinkedHashSet<String>();
        LinkedHashSet<String> footerJavaScriptSet = new LinkedHashSet<String>();
        LinkedHashSet<String> headerCssSet = new LinkedHashSet<String>();
        LinkedHashSet<String> headerJavaScriptSet = new LinkedHashSet<String>();
        boolean portletOnLayout = false;
        String rootPortletId = PortletJSONUtil._getRootPortletId(portlet);
        String portletId = portlet.getPortletId();
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        for (Portlet portlet2 : layoutTypePortlet.getAllPortlets()) {
            String layoutPortletRootPortletId = PortletJSONUtil._getRootPortletId(portlet2);
            if (!rootPortletId.equals(layoutPortletRootPortletId) || portletId.equals(portlet2.getPortletId())) continue;
            portletOnLayout = true;
            break;
        }
        if (!portletOnLayout && portlet.isAjaxable()) {
            Portlet rootPortlet = portlet.getRootPortlet();
            for (String footerPortalCss : portlet.getFooterPortalCss()) {
                if (!HttpUtil.hasProtocol(footerPortalCss)) {
                    footerPortalCss = PortalUtil.getPathContext() + footerPortalCss;
                    footerPortalCss = PortalUtil.getStaticResourceURL(request, footerPortalCss, rootPortlet.getTimestamp());
                }
                footerCssSet.add(footerPortalCss);
            }
            for (String footerPortalJavaScript : portlet.getFooterPortalJavaScript()) {
                if (!HttpUtil.hasProtocol(footerPortalJavaScript)) {
                    footerPortalJavaScript = PortalUtil.getPathContext() + footerPortalJavaScript;
                    footerPortalJavaScript = PortalUtil.getStaticResourceURL(request, footerPortalJavaScript, rootPortlet.getTimestamp());
                }
                footerJavaScriptSet.add(footerPortalJavaScript);
            }
            for (String footerPortletCss : portlet.getFooterPortletCss()) {
                if (!HttpUtil.hasProtocol(footerPortletCss)) {
                    footerPortletCss = portlet.getStaticResourcePath() + footerPortletCss;
                    footerPortletCss = PortalUtil.getStaticResourceURL(request, footerPortletCss, rootPortlet.getTimestamp());
                }
                footerCssSet.add(footerPortletCss);
            }
            for (String footerPortletJavaScript : portlet.getFooterPortletJavaScript()) {
                if (!HttpUtil.hasProtocol(footerPortletJavaScript)) {
                    footerPortletJavaScript = portlet.getStaticResourcePath() + footerPortletJavaScript;
                    footerPortletJavaScript = PortalUtil.getStaticResourceURL(request, footerPortletJavaScript, rootPortlet.getTimestamp());
                }
                footerJavaScriptSet.add(footerPortletJavaScript);
            }
            for (String headerPortalCss : portlet.getHeaderPortalCss()) {
                if (!HttpUtil.hasProtocol(headerPortalCss)) {
                    headerPortalCss = PortalUtil.getPathContext() + headerPortalCss;
                    headerPortalCss = PortalUtil.getStaticResourceURL(request, headerPortalCss, rootPortlet.getTimestamp());
                }
                headerCssSet.add(headerPortalCss);
            }
            for (String headerPortalJavaScript : portlet.getHeaderPortalJavaScript()) {
                if (!HttpUtil.hasProtocol(headerPortalJavaScript)) {
                    headerPortalJavaScript = PortalUtil.getPathContext() + headerPortalJavaScript;
                    headerPortalJavaScript = PortalUtil.getStaticResourceURL(request, headerPortalJavaScript, rootPortlet.getTimestamp());
                }
                headerJavaScriptSet.add(headerPortalJavaScript);
            }
            for (String headerPortletCss : portlet.getHeaderPortletCss()) {
                if (!HttpUtil.hasProtocol(headerPortletCss)) {
                    headerPortletCss = portlet.getStaticResourcePath() + headerPortletCss;
                    headerPortletCss = PortalUtil.getStaticResourceURL(request, headerPortletCss, rootPortlet.getTimestamp());
                }
                headerCssSet.add(headerPortletCss);
            }
            for (String headerPortletJavaScript : portlet.getHeaderPortletJavaScript()) {
                if (!HttpUtil.hasProtocol(headerPortletJavaScript)) {
                    headerPortletJavaScript = portlet.getStaticResourcePath() + headerPortletJavaScript;
                    headerPortletJavaScript = PortalUtil.getStaticResourceURL(request, headerPortletJavaScript, rootPortlet.getTimestamp());
                }
                headerJavaScriptSet.add(headerPortletJavaScript);
            }
        }
        String footerCssPaths = JSONFactoryUtil.serialize(footerCssSet.toArray(new String[0]));
        jsonObject.put("footerCssPaths", JSONFactoryUtil.createJSONArray(footerCssPaths));
        String string = JSONFactoryUtil.serialize(footerJavaScriptSet.toArray(new String[0]));
        jsonObject.put("footerJavaScriptPaths", JSONFactoryUtil.createJSONArray(string));
        String headerCssPaths = JSONFactoryUtil.serialize(headerCssSet.toArray(new String[0]));
        jsonObject.put("headerCssPaths", JSONFactoryUtil.createJSONArray(headerCssPaths));
        String headerJavaScriptPaths = JSONFactoryUtil.serialize(headerJavaScriptSet.toArray(new String[0]));
        jsonObject.put("headerJavaScriptPaths", JSONFactoryUtil.createJSONArray(headerJavaScriptPaths));
        List markupHeadElements = (List)request.getAttribute("javax.portlet.markup.head.element");
        if (markupHeadElements != null) {
            jsonObject.put("markupHeadElements", StringUtil.merge(markupHeadElements, ""));
        }
        jsonObject.put("portletHTML", portletHTML);
        jsonObject.put("refresh", !portlet.isAjaxable());
    }

    public static void writeFooterPaths(HttpServletResponse response, JSONObject jsonObject) throws IOException {
        PortletJSONUtil._writePaths(response, jsonObject.getJSONArray("footerCssPaths"), jsonObject.getJSONArray("footerJavaScriptPaths"));
    }

    public static void writeHeaderPaths(HttpServletResponse response, JSONObject jsonObject) throws IOException {
        PortletJSONUtil._writePaths(response, jsonObject.getJSONArray("headerCssPaths"), jsonObject.getJSONArray("headerJavaScriptPaths"));
    }

    private static String _getRootPortletId(Portlet portlet) {
        Portlet rootPortlet = portlet.getRootPortlet();
        return rootPortlet.getPortletId();
    }

    private static void _writePaths(HttpServletResponse response, JSONArray cssPathsJSONArray, JSONArray javaScriptPathsJSONArray) throws IOException {
        String value;
        int i;
        if (cssPathsJSONArray.length() == 0 && javaScriptPathsJSONArray.length() == 0) {
            return;
        }
        PrintWriter printWriter = response.getWriter();
        for (i = 0; i < cssPathsJSONArray.length(); ++i) {
            value = cssPathsJSONArray.getString(i);
            printWriter.print("<link href=\"");
            printWriter.print(HtmlUtil.escape(value));
            printWriter.println("\" rel=\"stylesheet\" type=\"text/css\" />");
        }
        for (i = 0; i < javaScriptPathsJSONArray.length(); ++i) {
            value = javaScriptPathsJSONArray.getString(i);
            printWriter.print("<script src=\"");
            printWriter.print(HtmlUtil.escape(value));
            printWriter.println("\" type=\"text/javascript\"></script>");
        }
    }
}

