/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.kernel.scheduler.JobState;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerEventMessageListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SchedulerEventMessageListenerWrapper
implements SchedulerEventMessageListener {
    private static final int _SCHEDULER_EVENT_MESSAGE_LISTENER_LOCK_TIMEOUT = GetterUtil.getInteger(PropsUtil.get("scheduler.event.message.listener.lock.timeout"));
    private static final Log _log = LogFactoryUtil.getLog(SchedulerEventMessageListenerWrapper.class);
    @Deprecated
    private String _groupName;
    @Deprecated
    private String _jobName;
    private final Lock _lock = new ReentrantLock();
    private MessageListener _messageListener;
    private volatile SchedulerEntry _schedulerEntry;

    @Override
    public SchedulerEntry getSchedulerEntry() {
        return this._schedulerEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(Message message) throws MessageListenerException {
        Trigger trigger;
        String destinationName = GetterUtil.getString(message.getString("DESTINATION_NAME"));
        String jobName = message.getString("JOB_NAME");
        String groupName = message.getString("GROUP_NAME");
        if (!(!destinationName.equals("liferay/scheduler_dispatch") || jobName.equals((trigger = this._schedulerEntry.getTrigger()).getJobName()) && groupName.equals(trigger.getGroupName()))) {
            return;
        }
        if (_SCHEDULER_EVENT_MESSAGE_LISTENER_LOCK_TIMEOUT <= 0) {
            this._lock.lock();
        } else {
            try {
                if (!this._lock.tryLock(_SCHEDULER_EVENT_MESSAGE_LISTENER_LOCK_TIMEOUT, TimeUnit.MILLISECONDS)) {
                    MessageBusUtil.sendMessage(destinationName, message);
                    return;
                }
            }
            catch (InterruptedException ie) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to wait " + _SCHEDULER_EVENT_MESSAGE_LISTENER_LOCK_TIMEOUT + " milliseconds before retry", ie);
                }
                return;
            }
        }
        try {
            this._processMessage(message, destinationName, jobName, groupName);
        }
        finally {
            this._lock.unlock();
        }
    }

    @Deprecated
    public void setGroupName(String groupName) {
        this._groupName = groupName;
    }

    @Deprecated
    public void setJobName(String jobName) {
        this._jobName = jobName;
    }

    public void setMessageListener(MessageListener messageListener) {
        this._messageListener = messageListener;
    }

    public void setSchedulerEntry(SchedulerEntry schedulerEntry) {
        this._schedulerEntry = schedulerEntry;
    }

    protected void handleException(Message message, Exception exception) {
        JobState jobState = (JobState)message.get("JOB_STATE");
        if (jobState != null) {
            jobState.addException(exception, new Date());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _processMessage(Message message, String destinationName, String jobName, String groupName) throws MessageListenerException {
        TriggerState triggerState;
        block19: {
            block16: {
                block17: {
                    try {
                        this._messageListener.receive(message);
                        triggerState = null;
                        if (!message.getBoolean("DISABLE")) break block16;
                        triggerState = TriggerState.COMPLETE;
                        if (!destinationName.equals("liferay/scheduler_dispatch")) break block17;
                    }
                    catch (Exception e) {
                        try {
                            this.handleException(message, e);
                            if (!(e instanceof MessageListenerException)) throw new MessageListenerException(e);
                            throw (MessageListenerException)e;
                        }
                        catch (Throwable throwable) {
                            TriggerState triggerState2;
                            block18: {
                                triggerState2 = null;
                                if (message.getBoolean("DISABLE")) {
                                    triggerState2 = TriggerState.COMPLETE;
                                    if (destinationName.equals("liferay/scheduler_dispatch")) {
                                        MessageBusUtil.unregisterMessageListener(destinationName, this);
                                    }
                                    StorageType storageType = (StorageType)((Object)message.get("STORAGE_TYPE"));
                                    try {
                                        SchedulerEngineHelperUtil.delete(jobName, groupName, storageType);
                                    }
                                    catch (SchedulerException se) {
                                        if (_log.isInfoEnabled()) {
                                            _log.info(StringBundler.concat("Unable to delete job ", jobName, " in group ", groupName), se);
                                        }
                                        break block18;
                                    }
                                }
                                triggerState2 = TriggerState.NORMAL;
                            }
                            try {
                                SchedulerEngineHelperUtil.auditSchedulerJobs(message, triggerState2);
                                throw throwable;
                            }
                            catch (Exception e2) {
                                if (!_log.isInfoEnabled()) throw throwable;
                                _log.info("Unable to send audit message", e2);
                            }
                            throw throwable;
                        }
                    }
                    MessageBusUtil.unregisterMessageListener(destinationName, this);
                }
                StorageType storageType = (StorageType)((Object)message.get("STORAGE_TYPE"));
                try {
                    SchedulerEngineHelperUtil.delete(jobName, groupName, storageType);
                }
                catch (SchedulerException se) {
                    if (_log.isInfoEnabled()) {
                        _log.info(StringBundler.concat("Unable to delete job ", jobName, " in group ", groupName), se);
                    }
                    break block19;
                }
            }
            triggerState = TriggerState.NORMAL;
        }
        try {
            SchedulerEngineHelperUtil.auditSchedulerJobs(message, triggerState);
            return;
        }
        catch (Exception e) {
            if (!_log.isInfoEnabled()) return;
            _log.info("Unable to send audit message", e);
            return;
        }
    }
}

