/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;

public class SearchContextFactory {
    public static SearchContext getInstance(HttpServletRequest request) {
        String[] scopes;
        SearchContext searchContext = new SearchContext();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        searchContext.setCompanyId(themeDisplay.getCompanyId());
        searchContext.setGroupIds(new long[]{themeDisplay.getScopeGroupId()});
        searchContext.setLayout(themeDisplay.getLayout());
        searchContext.setLocale(themeDisplay.getLocale());
        searchContext.setTimeZone(themeDisplay.getTimeZone());
        searchContext.setUserId(themeDisplay.getUserId());
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        Map parameters = request.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            Object[] values = (String[])entry.getValue();
            if (!ArrayUtil.isNotEmpty(values)) continue;
            String name = (String)entry.getKey();
            if (values.length == 1) {
                attributes.put(name, (Serializable)values[0]);
                continue;
            }
            attributes.put(name, (Serializable)values);
        }
        if (!parameters.containsKey("groupId") && (scopes = (String[])parameters.get("scope")) != null) {
            String groupId = "0";
            if (Objects.equals(scopes[0], "this-site")) {
                groupId = String.valueOf(themeDisplay.getScopeGroupId());
            }
            attributes.put("groupId", (Serializable)((Object)groupId));
        }
        searchContext.setAttributes(attributes);
        long[] assetCategoryIds = StringUtil.split(ParamUtil.getString(request, "assetCategoryIds"), 0L);
        String[] assetTagNames = StringUtil.split(ParamUtil.getString(request, "assetTagNames"));
        searchContext.setAssetCategoryIds(assetCategoryIds);
        searchContext.setAssetTagNames(assetTagNames);
        String keywords = ParamUtil.getString(request, "keywords");
        searchContext.setKeywords(keywords);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setLocale(themeDisplay.getLocale());
        return searchContext;
    }

    public static SearchContext getInstance(long[] assetCategoryIds, String[] assetTagNames, Map<String, Serializable> attributes, long companyId, String keywords, Layout layout, Locale locale, long scopeGroupId, TimeZone timeZone, long userId) {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setGroupIds(new long[]{scopeGroupId});
        searchContext.setLayout(layout);
        searchContext.setLocale(locale);
        searchContext.setTimeZone(timeZone);
        searchContext.setUserId(userId);
        if (attributes != null) {
            searchContext.setAttributes(attributes);
        } else {
            searchContext.setAttributes(new HashMap<String, Serializable>());
        }
        searchContext.setAssetCategoryIds(assetCategoryIds);
        searchContext.setAssetTagNames(assetTagNames);
        searchContext.setKeywords(keywords);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setLocale(locale);
        return searchContext;
    }
}

