/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.access.control;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.internal.security.access.control.AllowedIPAddressesValidator;
import com.liferay.portal.kernel.internal.security.access.control.AllowedIPAddressesValidatorFactory;
import com.liferay.portal.kernel.security.access.control.AccessControl;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AccessControlUtil {
    private static final String _SERVER_IP = "SERVER_IP";
    private static final AccessControlUtil _instance = new AccessControlUtil();
    private static final ThreadLocal<AccessControlContext> _accessControlContext = new CentralizedThreadLocal(AccessControlUtil.class + "._accessControlContext");
    private final ServiceTracker<?, AccessControl> _serviceTracker;

    public static AccessControl getAccessControl() {
        return (AccessControl)AccessControlUtil._instance._serviceTracker.getService();
    }

    public static AccessControlContext getAccessControlContext() {
        return _accessControlContext.get();
    }

    public static void initAccessControlContext(HttpServletRequest request, HttpServletResponse response, Map<String, Object> settings) {
        AccessControlUtil.getAccessControl().initAccessControlContext(request, response, settings);
    }

    public static void initContextUser(long userId) throws AuthException {
        AccessControlUtil.getAccessControl().initContextUser(userId);
    }

    public static boolean isAccessAllowed(HttpServletRequest request, Set<String> hostsAllowed) {
        if (hostsAllowed.isEmpty()) {
            return true;
        }
        String remoteAddr = request.getRemoteAddr();
        for (String hostAllowed : hostsAllowed) {
            AllowedIPAddressesValidator allowedIPAddressesValidator = AllowedIPAddressesValidatorFactory.create(hostAllowed);
            if (!allowedIPAddressesValidator.isAllowedIPAddress(remoteAddr)) continue;
            return true;
        }
        Set<String> computerAddresses = PortalUtil.getComputerAddresses();
        return computerAddresses.contains(remoteAddr) && hostsAllowed.contains(_SERVER_IP);
    }

    public static void setAccessControlContext(AccessControlContext accessControlContext) {
        _accessControlContext.set(accessControlContext);
    }

    public static AuthVerifierResult.State verifyRequest() throws PortalException {
        return AccessControlUtil.getAccessControl().verifyRequest();
    }

    private AccessControlUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(AccessControl.class);
        this._serviceTracker.open();
    }
}

