/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service;

import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class ServiceContextFactory {
    private static final Log _log = LogFactoryUtil.getLog(ServiceContextFactory.class);

    public static ServiceContext getInstance(HttpServletRequest request) throws PortalException {
        ModelPermissions modelPermissions;
        ServiceContext serviceContext = new ServiceContext();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            String canonicalURL;
            serviceContext.setCompanyId(themeDisplay.getCompanyId());
            serviceContext.setLanguageId(themeDisplay.getLanguageId());
            String layoutURL = PortalUtil.getLayoutURL(themeDisplay);
            String fullCanonicalURL = canonicalURL = PortalUtil.getCanonicalURL(layoutURL, themeDisplay, themeDisplay.getLayout(), true);
            if (!HttpUtil.hasProtocol(layoutURL)) {
                fullCanonicalURL = PortalUtil.getCanonicalURL(PortalUtil.getPortalURL(themeDisplay) + layoutURL, themeDisplay, themeDisplay.getLayout(), true);
            }
            serviceContext.setLayoutFullURL(fullCanonicalURL);
            serviceContext.setLayoutURL(canonicalURL);
            serviceContext.setPlid(themeDisplay.getPlid());
            serviceContext.setScopeGroupId(themeDisplay.getScopeGroupId());
            serviceContext.setSignedIn(themeDisplay.isSignedIn());
            serviceContext.setTimeZone(themeDisplay.getTimeZone());
            serviceContext.setUserId(themeDisplay.getUserId());
        } else {
            User user;
            block18: {
                serviceContext.setCompanyId(PortalUtil.getCompanyId(request));
                Group guestGroup = GroupLocalServiceUtil.getGroup(serviceContext.getCompanyId(), "Guest");
                serviceContext.setScopeGroupId(guestGroup.getGroupId());
                user = null;
                try {
                    user = PortalUtil.getUser(request);
                }
                catch (NoSuchUserException nsue) {
                    if (!_log.isDebugEnabled()) break block18;
                    _log.debug(nsue, nsue);
                }
            }
            if (user != null) {
                serviceContext.setSignedIn(!user.isDefaultUser());
                serviceContext.setUserId(user.getUserId());
            } else {
                serviceContext.setSignedIn(false);
            }
        }
        serviceContext.setPortalURL(PortalUtil.getPortalURL(request));
        serviceContext.setPathMain(PortalUtil.getPathMain());
        serviceContext.setPathFriendlyURLPrivateGroup(PortalUtil.getPathFriendlyURLPrivateGroup());
        serviceContext.setPathFriendlyURLPrivateUser(PortalUtil.getPathFriendlyURLPrivateUser());
        serviceContext.setPathFriendlyURLPublic(PortalUtil.getPathFriendlyURLPublic());
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        Map parameters = request.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            String name = (String)entry.getKey();
            Object[] values = (String[])entry.getValue();
            if (!ArrayUtil.isNotEmpty(values)) continue;
            if (values.length == 1) {
                attributes.put(name, (Serializable)values[0]);
                continue;
            }
            attributes.put(name, (Serializable)values);
        }
        serviceContext.setAttributes(attributes);
        serviceContext.setCommand(ParamUtil.getString(request, "cmd"));
        serviceContext.setCurrentURL(PortalUtil.getCurrentURL(request));
        long formDateLong = ParamUtil.getLong(request, "formDate");
        if (formDateLong > 0L) {
            serviceContext.setFormDate(new Date(formDateLong));
        }
        if (!(modelPermissions = ModelPermissionsFactory.create(request)).isEmpty()) {
            serviceContext.setModelPermissions(modelPermissions);
        } else {
            serviceContext.setAddGroupPermissions(ParamUtil.getBoolean(request, "addGroupPermissions"));
            serviceContext.setAddGuestPermissions(ParamUtil.getBoolean(request, "addGuestPermissions"));
            serviceContext.setGroupPermissions(PortalUtil.getGroupPermissions(request));
            serviceContext.setGuestPermissions(PortalUtil.getGuestPermissions(request));
        }
        String portletId = PortalUtil.getPortletId(request);
        if (Validator.isNotNull(portletId)) {
            serviceContext.setPortletId(portletId);
        }
        serviceContext.setRemoteAddr(request.getRemoteAddr());
        serviceContext.setRemoteHost(request.getRemoteHost());
        serviceContext.setRequest(request);
        Map parameterMap = request.getParameterMap();
        ArrayList<Long> assetCategoryIdsList = new ArrayList<Long>();
        boolean updateAssetCategoryIds = false;
        for (Map.Entry entry : parameterMap.entrySet()) {
            long[] assetVocabularyAssetCategoryIds;
            String name = (String)entry.getKey();
            if (!name.startsWith("assetCategoryIds")) continue;
            updateAssetCategoryIds = true;
            for (long assetCategoryId : assetVocabularyAssetCategoryIds = StringUtil.split(ParamUtil.getString(request, name), 0L)) {
                assetCategoryIdsList.add(assetCategoryId);
            }
        }
        if (updateAssetCategoryIds) {
            serviceContext.setAssetCategoryIds(ArrayUtil.toArray(assetCategoryIdsList.toArray(new Long[0])));
        }
        serviceContext.setAssetEntryVisible(ParamUtil.getBoolean(request, "assetEntryVisible", true));
        String assetLinkEntryIdsString = request.getParameter("assetLinksSearchContainerPrimaryKeys");
        if (assetLinkEntryIdsString != null) {
            serviceContext.setAssetLinkEntryIds(StringUtil.split(assetLinkEntryIdsString, 0L));
        }
        serviceContext.setAssetPriority(ParamUtil.getDouble(request, "assetPriority"));
        String assetTagNamesString = request.getParameter("assetTagNames");
        if (assetTagNamesString != null) {
            serviceContext.setAssetTagNames(StringUtil.split(assetTagNamesString));
        }
        serviceContext.setWorkflowAction(ParamUtil.getInteger(request, "workflowAction", 1));
        return serviceContext;
    }

    public static ServiceContext getInstance(PortletRequest portletRequest) throws PortalException {
        ModelPermissions modelPermissions;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (serviceContext != null) {
            serviceContext = (ServiceContext)serviceContext.clone();
        } else {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(themeDisplay.getCompanyId());
            serviceContext.setLanguageId(themeDisplay.getLanguageId());
            serviceContext.setLayoutFullURL(PortalUtil.getLayoutFullURL(themeDisplay));
            serviceContext.setLayoutURL(PortalUtil.getLayoutURL(themeDisplay));
            serviceContext.setPathFriendlyURLPrivateGroup(PortalUtil.getPathFriendlyURLPrivateGroup());
            serviceContext.setPathFriendlyURLPrivateUser(PortalUtil.getPathFriendlyURLPrivateUser());
            serviceContext.setPathFriendlyURLPublic(PortalUtil.getPathFriendlyURLPublic());
            serviceContext.setPathMain(PortalUtil.getPathMain());
            serviceContext.setPlid(themeDisplay.getPlid());
            serviceContext.setPortalURL(PortalUtil.getPortalURL(portletRequest));
            serviceContext.setSignedIn(themeDisplay.isSignedIn());
            serviceContext.setTimeZone(themeDisplay.getTimeZone());
            serviceContext.setUserId(themeDisplay.getUserId());
        }
        serviceContext.setScopeGroupId(themeDisplay.getScopeGroupId());
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        Enumeration enu = portletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String param = (String)enu.nextElement();
            Object[] values = portletRequest.getParameterValues(param);
            if (!ArrayUtil.isNotEmpty(values)) continue;
            if (values.length == 1) {
                attributes.put(param, (Serializable)values[0]);
                continue;
            }
            attributes.put(param, (Serializable)values);
        }
        serviceContext.setAttributes(attributes);
        String cmd = ParamUtil.getString(portletRequest, "cmd");
        serviceContext.setCommand(cmd);
        String currentURL = PortalUtil.getCurrentURL(portletRequest);
        serviceContext.setCurrentURL(currentURL);
        long formDateLong = ParamUtil.getLong(portletRequest, "formDate");
        if (formDateLong > 0L) {
            Date formDate = new Date(formDateLong);
            serviceContext.setFormDate(formDate);
        }
        if (!(modelPermissions = ModelPermissionsFactory.create(portletRequest)).isEmpty()) {
            serviceContext.setModelPermissions(modelPermissions);
        } else {
            boolean addGroupPermissions = ParamUtil.getBoolean(portletRequest, "addGroupPermissions");
            boolean addGuestPermissions = ParamUtil.getBoolean(portletRequest, "addGuestPermissions");
            String[] groupPermissions = PortalUtil.getGroupPermissions(portletRequest);
            String[] guestPermissions = PortalUtil.getGuestPermissions(portletRequest);
            serviceContext.setAddGroupPermissions(addGroupPermissions);
            serviceContext.setAddGuestPermissions(addGuestPermissions);
            serviceContext.setGroupPermissions(groupPermissions);
            serviceContext.setGuestPermissions(guestPermissions);
        }
        HttpServletRequest request = PortalUtil.getHttpServletRequest(portletRequest);
        serviceContext.setPortletId(PortalUtil.getPortletId(portletRequest));
        serviceContext.setRemoteAddr(request.getRemoteAddr());
        serviceContext.setRemoteHost(request.getRemoteHost());
        serviceContext.setRequest(request);
        Map parameterMap = portletRequest.getParameterMap();
        ArrayList<Long> assetCategoryIdsList = new ArrayList<Long>();
        boolean updateAssetCategoryIds = false;
        for (Map.Entry entry : parameterMap.entrySet()) {
            long[] assetVocabularyAssetCategoryIds;
            String name = (String)entry.getKey();
            if (!name.startsWith("assetCategoryIds")) continue;
            updateAssetCategoryIds = true;
            for (long assetCategoryId : assetVocabularyAssetCategoryIds = StringUtil.split(ParamUtil.getString(portletRequest, name), 0L)) {
                assetCategoryIdsList.add(assetCategoryId);
            }
        }
        if (updateAssetCategoryIds) {
            long[] assetCategoryIds = ArrayUtil.toArray(assetCategoryIdsList.toArray(new Long[0]));
            serviceContext.setAssetCategoryIds(assetCategoryIds);
        }
        boolean assetEntryVisible = ParamUtil.getBoolean(portletRequest, "assetEntryVisible", true);
        serviceContext.setAssetEntryVisible(assetEntryVisible);
        String assetLinkEntryIdsString = request.getParameter("assetLinksSearchContainerPrimaryKeys");
        if (assetLinkEntryIdsString != null) {
            long[] assetLinkEntryIds = StringUtil.split(assetLinkEntryIdsString, 0L);
            serviceContext.setAssetLinkEntryIds(assetLinkEntryIds);
        }
        Double assetPriority = ParamUtil.getDouble(request, "assetPriority");
        serviceContext.setAssetPriority(assetPriority);
        String assetTagNamesString = request.getParameter("assetTagNames");
        if (assetTagNamesString != null) {
            String[] assetTagNames = StringUtil.split(assetTagNamesString);
            serviceContext.setAssetTagNames(assetTagNames);
        }
        int workflowAction = ParamUtil.getInteger(portletRequest, "workflowAction", 1);
        serviceContext.setWorkflowAction(workflowAction);
        return serviceContext;
    }

    public static ServiceContext getInstance(String className, HttpServletRequest request) throws PortalException {
        ServiceContext serviceContext = ServiceContextFactory.getInstance(request);
        String[] groupPermissions = PortalUtil.getGroupPermissions(request, className);
        String[] guestPermissions = PortalUtil.getGuestPermissions(request, className);
        if (groupPermissions != null) {
            serviceContext.setGroupPermissions(groupPermissions);
        }
        if (guestPermissions != null) {
            serviceContext.setGuestPermissions(guestPermissions);
        }
        Map<String, Serializable> expandoBridgeAttributes = PortalUtil.getExpandoBridgeAttributes(ExpandoBridgeFactoryUtil.getExpandoBridge(serviceContext.getCompanyId(), className), request);
        serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        return serviceContext;
    }

    public static ServiceContext getInstance(String className, PortletRequest portletRequest) throws PortalException {
        ServiceContext serviceContext = ServiceContextFactory.getInstance(portletRequest);
        String[] groupPermissions = PortalUtil.getGroupPermissions(portletRequest, className);
        String[] guestPermissions = PortalUtil.getGuestPermissions(portletRequest, className);
        if (groupPermissions != null) {
            serviceContext.setGroupPermissions(groupPermissions);
        }
        if (guestPermissions != null) {
            serviceContext.setGuestPermissions(guestPermissions);
        }
        Map<String, Serializable> expandoBridgeAttributes = PortalUtil.getExpandoBridgeAttributes(ExpandoBridgeFactoryUtil.getExpandoBridge(serviceContext.getCompanyId(), className), portletRequest);
        serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        return serviceContext;
    }

    public static ServiceContext getInstance(String className, UploadPortletRequest uploadPortletRequest) throws PortalException {
        ServiceContext serviceContext = ServiceContextFactory.getInstance(uploadPortletRequest);
        String[] groupPermissions = PortalUtil.getGroupPermissions(uploadPortletRequest, className);
        String[] guestPermissions = PortalUtil.getGuestPermissions(uploadPortletRequest, className);
        if (groupPermissions != null) {
            serviceContext.setGroupPermissions(groupPermissions);
        }
        if (guestPermissions != null) {
            serviceContext.setGuestPermissions(guestPermissions);
        }
        Map<String, Serializable> expandoBridgeAttributes = PortalUtil.getExpandoBridgeAttributes(ExpandoBridgeFactoryUtil.getExpandoBridge(serviceContext.getCompanyId(), className), uploadPortletRequest);
        serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        return serviceContext;
    }
}

