/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service.permission;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.ListUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModelPermissions
implements Cloneable,
Serializable {
    private final Map<String, Set<String>> _actionIdsMap = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> _roleNamesMap = new HashMap<String, Set<String>>();

    public ModelPermissions() {
    }

    public void addRolePermissions(String roleName, String actionId) {
        Set<String> roleNames = this._roleNamesMap.get(actionId);
        if (roleNames == null) {
            roleNames = new HashSet<String>();
            this._roleNamesMap.put(actionId, roleNames);
        }
        roleNames.add(roleName);
        Set<String> actionIds = this._actionIdsMap.get(roleName);
        if (actionIds == null) {
            actionIds = new HashSet<String>();
            this._actionIdsMap.put(roleName, actionIds);
        }
        actionIds.add(actionId);
    }

    public void addRolePermissions(String roleName, String[] actionIds) {
        if (actionIds == null) {
            return;
        }
        for (String actionId : actionIds) {
            this.addRolePermissions(roleName, actionId);
        }
    }

    public Object clone() {
        return new ModelPermissions(new HashMap<String, Set<String>>(this._roleNamesMap), new HashMap<String, Set<String>>(this._actionIdsMap));
    }

    public String[] getActionIds(String roleName) {
        Set<String> actionIds = this._actionIdsMap.get(roleName);
        if (actionIds == null) {
            return StringPool.EMPTY_ARRAY;
        }
        return actionIds.toArray(new String[0]);
    }

    public List<String> getActionIdsList(String roleName) {
        Set<String> actionIds = this._actionIdsMap.get(roleName);
        return ListUtil.fromCollection(actionIds);
    }

    public Collection<String> getRoleNames() {
        return this._actionIdsMap.keySet();
    }

    public Collection<String> getRoleNames(String actionId) {
        Set<String> roleNames = this._roleNamesMap.get(actionId);
        if (roleNames == null) {
            roleNames = new HashSet<String>();
        }
        return roleNames;
    }

    public boolean isEmpty() {
        return this._actionIdsMap.isEmpty();
    }

    protected ModelPermissions(Map<String, Set<String>> roleNamesMap, Map<String, Set<String>> actionIdsMap) {
        this._roleNamesMap.putAll(roleNamesMap);
        this._actionIdsMap.putAll(actionIdsMap);
    }
}

