/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.servlet.Header;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class MetaInfoCacheServletResponse
extends HttpServletResponseWrapper {
    protected boolean calledGetOutputStream;
    protected boolean calledGetWriter;
    private boolean _committed;
    private final MetaData _metaData = new MetaData();

    public static void finishResponse(MetaData metaInfoDataBag, HttpServletResponse response) throws IOException {
        if (response.isCommitted()) {
            return;
        }
        MetaInfoCacheServletResponse.resetThrough(response);
        for (Map.Entry entry : metaInfoDataBag._headers.entrySet()) {
            String key = (String)entry.getKey();
            boolean first = true;
            for (Header header : (Set)entry.getValue()) {
                if (first) {
                    header.setToResponse(key, response);
                    first = false;
                    continue;
                }
                header.addToResponse(key, response);
            }
        }
        if (metaInfoDataBag._location != null) {
            response.sendRedirect(metaInfoDataBag._location);
        } else if (metaInfoDataBag._error) {
            response.sendError(metaInfoDataBag._status, metaInfoDataBag._errorMessage);
        } else {
            if (metaInfoDataBag._charsetName != null) {
                response.setCharacterEncoding(metaInfoDataBag._charsetName);
            }
            if (metaInfoDataBag._contentLength != -1L) {
                response.setContentLengthLong(metaInfoDataBag._contentLength);
            }
            if (metaInfoDataBag._contentType != null) {
                response.setContentType(metaInfoDataBag._contentType);
            }
            if (metaInfoDataBag._locale != null) {
                response.setLocale(metaInfoDataBag._locale);
            }
            if (metaInfoDataBag._status != 200) {
                response.setStatus(metaInfoDataBag._status, metaInfoDataBag._statusMessage);
            }
        }
    }

    public MetaInfoCacheServletResponse(HttpServletResponse response) {
        super(response);
    }

    public void addCookie(Cookie cookie) {
        HashSet<Header> values = (HashSet<Header>)this._metaData._headers.get("Set-Cookie");
        if (values == null) {
            values = new HashSet<Header>();
            this._metaData._headers.put("Set-Cookie", values);
        }
        Header header = new Header(cookie);
        values.add(header);
        super.addCookie(cookie);
    }

    public void addDateHeader(String name, long value) {
        HashSet<Header> values = (HashSet<Header>)this._metaData._headers.get(name);
        if (values == null) {
            values = new HashSet<Header>();
            this._metaData._headers.put(name, values);
        }
        Header header = new Header(value);
        values.add(header);
        super.addDateHeader(name, value);
    }

    public void addHeader(String name, String value) {
        if (name.equals("Content-Type")) {
            this.setContentType(value);
            return;
        }
        HashSet<Header> values = (HashSet<Header>)this._metaData._headers.get(name);
        if (values == null) {
            values = new HashSet<Header>();
            this._metaData._headers.put(name, values);
        }
        Header header = new Header(value);
        values.add(header);
        super.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        HashSet<Header> values = (HashSet<Header>)this._metaData._headers.get(name);
        if (values == null) {
            values = new HashSet<Header>();
            this._metaData._headers.put(name, values);
        }
        Header header = new Header(value);
        values.add(header);
        super.addIntHeader(name, value);
    }

    public boolean containsHeader(String name) {
        return this._metaData._headers.containsKey(name);
    }

    public void finishResponse() throws IOException {
        MetaInfoCacheServletResponse.finishResponse(this._metaData, (HttpServletResponse)this.getResponse());
        this._committed = true;
    }

    @Deprecated
    public void finishResponse(boolean reapplyMetaData) throws IOException {
        if (reapplyMetaData) {
            HttpServletResponse response = (HttpServletResponse)this.getResponse();
            MetaInfoCacheServletResponse.finishResponse(this._metaData, response);
        }
        this._committed = true;
    }

    public void flushBuffer() throws IOException {
        this._committed = true;
    }

    public int getBufferSize() {
        return this._metaData._bufferSize;
    }

    public String getCharacterEncoding() {
        if (this._metaData._charsetName == null) {
            return StringPool.DEFAULT_CHARSET_NAME;
        }
        return this._metaData._charsetName;
    }

    public String getContentType() {
        String contentType = this._metaData._contentType;
        if (contentType != null && this._metaData._charsetName != null) {
            contentType = contentType.concat("; charset=").concat(this._metaData._charsetName);
        }
        return contentType;
    }

    public String getHeader(String name) {
        Set values = (Set)this._metaData._headers.get(name);
        if (values == null) {
            return null;
        }
        Iterator iterator = values.iterator();
        Header header = (Header)iterator.next();
        return header.toString();
    }

    public Collection<String> getHeaderNames() {
        return this._metaData._headers.keySet();
    }

    public Map<String, Set<Header>> getHeaders() {
        return this._metaData._headers;
    }

    public Collection<String> getHeaders(String name) {
        Set values = (Set)this._metaData._headers.get(name);
        if (values == null) {
            return Collections.emptyList();
        }
        ArrayList<String> stringValues = new ArrayList<String>();
        for (Header header : values) {
            stringValues.add(header.toString());
        }
        return stringValues;
    }

    public Locale getLocale() {
        return this._metaData._locale;
    }

    public MetaData getMetaData() {
        return this._metaData;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.calledGetOutputStream = true;
        return super.getOutputStream();
    }

    public int getStatus() {
        return this._metaData._status;
    }

    public PrintWriter getWriter() throws IOException {
        this.calledGetWriter = true;
        return super.getWriter();
    }

    public boolean isCommitted() {
        ServletResponse servletResponse = this.getResponse();
        return this._committed || servletResponse.isCommitted();
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Reset after commit");
        }
        this._metaData._charsetName = null;
        this._metaData._contentLength = -1L;
        this._metaData._contentType = null;
        this._metaData._headers.clear();
        this._metaData._locale = null;
        this._metaData._status = 200;
        this._metaData._statusMessage = null;
        this.resetBuffer();
        super.reset();
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Reset buffer after commit");
        }
        this.resetBuffer(false);
    }

    public void sendError(int status) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Send error after commit");
        }
        this._metaData._error = true;
        this._metaData._status = status;
        this.resetBuffer();
        this._committed = true;
        super.sendError(status);
    }

    public void sendError(int status, String errorMessage) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Send error after commit");
        }
        this._metaData._error = true;
        this._metaData._errorMessage = errorMessage;
        this._metaData._status = status;
        this.resetBuffer();
        this._committed = true;
        super.sendError(status, errorMessage);
    }

    public void sendRedirect(String location) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Send redirect after commit");
        }
        this.resetBuffer(true);
        this.setStatus(302);
        this._metaData._location = location;
        this._committed = true;
        super.sendRedirect(location);
    }

    public void setBufferSize(int bufferSize) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Set buffer size after commit");
        }
        this._metaData._bufferSize = bufferSize;
        super.setBufferSize(bufferSize);
    }

    public void setCharacterEncoding(String charsetName) {
        if (this.isCommitted()) {
            return;
        }
        this._setCharacterEncoding(charsetName);
    }

    public void setContentLength(int contentLength) {
        if (this.isCommitted()) {
            return;
        }
        this._metaData._contentLength = contentLength;
        super.setContentLength(contentLength);
    }

    public void setContentLengthLong(long contentLength) {
        if (this.isCommitted()) {
            return;
        }
        this._metaData._contentLength = contentLength;
        super.setContentLengthLong(contentLength);
    }

    public void setContentType(String contentType) {
        if (this.isCommitted()) {
            return;
        }
        if (contentType == null) {
            return;
        }
        int index = contentType.indexOf(59);
        if (index != -1) {
            String firstPart = contentType.substring(0, index);
            this._metaData._contentType = firstPart.trim();
            index = contentType.indexOf("charset=");
            if (index != -1) {
                String charsetName = contentType.substring(index + 8);
                charsetName = charsetName.trim();
                this._setCharacterEncoding(charsetName);
            } else {
                this._metaData._charsetName = null;
            }
        } else {
            this._metaData._contentType = contentType;
            this._metaData._charsetName = null;
        }
        super.setContentType(contentType);
    }

    public void setDateHeader(String name, long value) {
        HashSet<Header> values = new HashSet<Header>();
        this._metaData._headers.put(name, values);
        Header header = new Header(value);
        values.add(header);
        super.setDateHeader(name, value);
    }

    public void setHeader(String name, String value) {
        if (name.equals("Content-Type")) {
            this.setContentType(value);
            return;
        }
        HashSet<Header> values = new HashSet<Header>();
        this._metaData._headers.put(name, values);
        Header header = new Header(value);
        values.add(header);
        super.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        HashSet<Header> values = new HashSet<Header>();
        this._metaData._headers.put(name, values);
        Header header = new Header(value);
        values.add(header);
        super.setIntHeader(name, value);
    }

    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        this._metaData._locale = locale;
        super.setLocale(locale);
    }

    public void setStatus(int status) {
        if (this.isCommitted()) {
            return;
        }
        this._metaData._status = status;
        super.setStatus(status);
    }

    public void setStatus(int status, String statusMessage) {
        if (this.isCommitted()) {
            return;
        }
        this._metaData._status = status;
        this._metaData._statusMessage = statusMessage;
        super.setStatus(status, statusMessage);
    }

    public String toString() {
        StringBundler sb = new StringBundler(23);
        sb.append("{bufferSize=");
        sb.append(this._metaData._bufferSize);
        sb.append(", charsetName=");
        sb.append(this._metaData._charsetName);
        sb.append(", committed=");
        sb.append(this._committed);
        sb.append(", contentLength=");
        sb.append(this._metaData._contentLength);
        sb.append(", contentType=");
        sb.append(this._metaData._contentType);
        sb.append(", error=");
        sb.append(this._metaData._error);
        sb.append(", errorMessage=");
        sb.append(this._metaData._errorMessage);
        sb.append(", headers=");
        sb.append(this._metaData._headers);
        sb.append(", location=");
        sb.append(this._metaData._location);
        sb.append(", locale=");
        sb.append(this._metaData._locale);
        sb.append(", status=");
        sb.append(this._metaData._status);
        sb.append("}");
        return sb.toString();
    }

    protected static void resetThrough(HttpServletResponse response) {
        if (response instanceof MetaInfoCacheServletResponse) {
            MetaInfoCacheServletResponse metaInfoCacheServletResponse = (MetaInfoCacheServletResponse)response;
            MetaInfoCacheServletResponse.resetThrough((HttpServletResponse)metaInfoCacheServletResponse.getResponse());
        } else {
            response.reset();
        }
    }

    protected void resetBuffer(boolean nullOutReferences) {
        super.resetBuffer();
    }

    private void _setCharacterEncoding(String charsetName) {
        if (this.calledGetWriter) {
            return;
        }
        if (charsetName == null) {
            return;
        }
        this._metaData._charsetName = charsetName;
        super.setCharacterEncoding(charsetName);
    }

    public static class MetaData
    implements Serializable {
        private int _bufferSize;
        private String _charsetName;
        private long _contentLength = -1L;
        private String _contentType;
        private boolean _error;
        private String _errorMessage;
        private final Map<String, Set<Header>> _headers = new HashMap<String, Set<Header>>();
        private Locale _locale;
        private String _location;
        private int _status = 200;
        private String _statusMessage;
    }
}

