/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.NonSerializableObjectHandler;
import com.liferay.portal.kernel.servlet.PersistentHttpServletRequestWrapper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.lang.reflect.Field;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class NonSerializableObjectRequestWrapper
extends PersistentHttpServletRequestWrapper {
    private static final boolean _WEBLOGIC_REQUEST_WRAP_NON_SERIALIZABLE = GetterUtil.getBoolean(PropsUtil.get("weblogic.request.wrap.non.serializable"));
    private static final Log _log = LogFactoryUtil.getLog(NonSerializableObjectRequestWrapper.class);

    public static boolean isWrapped(HttpServletRequest request) {
        if (!_WEBLOGIC_REQUEST_WRAP_NON_SERIALIZABLE) {
            return false;
        }
        Class<?> clazz = request.getClass();
        String className = clazz.getName();
        if (className.startsWith("weblogic.")) {
            request.removeAttribute(NonSerializableObjectRequestWrapper.class.getName());
            return false;
        }
        Boolean wrapped = (Boolean)request.getAttribute(NonSerializableObjectRequestWrapper.class.getName());
        if (wrapped == null) {
            return false;
        }
        return wrapped;
    }

    public NonSerializableObjectRequestWrapper(HttpServletRequest request) {
        super(request);
        request.setAttribute(NonSerializableObjectRequestWrapper.class.getName(), (Object)Boolean.TRUE);
    }

    public Object getAttribute(String name) {
        Object object = null;
        try {
            object = super.getAttribute(name);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null || !message.contains("BEA-101362")) {
                _log.error(e, e);
            }
            return null;
        }
        object = NonSerializableObjectHandler.getValue(object);
        return object;
    }

    public void setAttribute(String name, Object object) {
        if (_WEBLOGIC_REQUEST_WRAP_NON_SERIALIZABLE && !(object instanceof NonSerializableObjectHandler)) {
            object = new NonSerializableObjectHandler(object);
        }
        super.setAttribute(name, object);
        this._setWebLogicClassLoaderFlag(name);
    }

    private void _setWebLogicClassLoaderFlag(String attributeName) {
        block4: {
            ServletRequest servletRequest = this.getRequest();
            try {
                Field servletRequestAttributesField = ReflectionUtil.getDeclaredField(servletRequest.getClass(), (String)"attributes");
                Object servletRequestAttributes = servletRequestAttributesField.get(servletRequest);
                Field attributesField = ReflectionUtil.getDeclaredField(servletRequestAttributes.getClass(), (String)"attributes");
                Map map = (Map)attributesField.get(servletRequestAttributes);
                Object attribute = map.get(attributeName);
                Field isWebLogicClassLoaderField = ReflectionUtil.getDeclaredField(attribute.getClass(), (String)"isWebLogicClassLoader");
                isWebLogicClassLoaderField.set(attribute, false);
            }
            catch (NoSuchFieldException nsfe) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Unable to get fields from a Weblogic servlet request");
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug(StringBundler.concat("Unable to set WebLogic class loader flag for ", "attribute ", attributeName, " in servlet request ", String.valueOf(servletRequest)));
            }
        }
    }
}

