/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.BaseMapBuilder;
import com.liferay.portal.kernel.util.BaseMapWrapper;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentHashMapBuilder<K, V>
extends BaseMapBuilder {
    public static <K, V> ConcurrentHashMapWrapper<K, V> put(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
        return new ConcurrentHashMapWrapper<Collection<? extends K>, BaseMapBuilder.UnsafeFunction<K, V, Exception>>(inputCollection, unsafeFunction);
    }

    public static <K, V> ConcurrentHashMapWrapper<K, V> put(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        return new ConcurrentHashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>>(key, valueUnsafeSupplier);
    }

    public static <K, V> ConcurrentHashMapWrapper<K, V> put(K key, V value) {
        return new ConcurrentHashMapWrapper<K, V>(key, value);
    }

    public static <K, V> ConcurrentHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        return new ConcurrentHashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>>(keyUnsafeSupplier, valueUnsafeSupplier);
    }

    public static <K, V> ConcurrentHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
        return new ConcurrentHashMapWrapper<K, V>(keyUnsafeSupplier, value);
    }

    public static <K, V> ConcurrentHashMapWrapper<K, V> putAll(Map<? extends K, ? extends V> inputMap) {
        return new ConcurrentHashMapWrapper<K, V>(inputMap);
    }

    public static final class ConcurrentHashMapWrapper<K, V>
    extends BaseMapWrapper<K, V> {
        private final ConcurrentHashMap<K, V> _concurrentHashMap = new ConcurrentHashMap();

        public ConcurrentHashMapWrapper(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
            this.doPut(inputCollection, unsafeFunction);
        }

        public ConcurrentHashMapWrapper(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(key, valueUnsafeSupplier);
        }

        public ConcurrentHashMapWrapper(K key, V value) {
            this._concurrentHashMap.put(key, value);
        }

        public ConcurrentHashMapWrapper(Map<? extends K, ? extends V> inputMap) {
            this.doPutAll(inputMap);
        }

        public ConcurrentHashMapWrapper(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(keyUnsafeSupplier, valueUnsafeSupplier);
        }

        public ConcurrentHashMapWrapper(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
            this.doPut(keyUnsafeSupplier, value);
        }

        public ConcurrentHashMap<K, V> build() {
            return this._concurrentHashMap;
        }

        public ConcurrentHashMapWrapper<K, V> put(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
            this.doPut(inputCollection, unsafeFunction);
            return this;
        }

        public ConcurrentHashMapWrapper<K, V> put(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(key, valueUnsafeSupplier);
            return this;
        }

        public ConcurrentHashMapWrapper<K, V> put(K key, V value) {
            this._concurrentHashMap.put(key, value);
            return this;
        }

        public ConcurrentHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(keyUnsafeSupplier, valueUnsafeSupplier);
            return this;
        }

        public ConcurrentHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
            this.doPut(keyUnsafeSupplier, value);
            return this;
        }

        public ConcurrentHashMapWrapper<K, V> putAll(Map<? extends K, ? extends V> inputMap) {
            this.doPutAll(inputMap);
            return this;
        }

        @Override
        protected ConcurrentHashMap<K, V> getMap() {
            return this._concurrentHashMap;
        }
    }
}

