/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.xml.Document;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class LocalizationUtil {
    private static Localization _localization;

    public static Object deserialize(JSONObject jsonObject) {
        return LocalizationUtil.getLocalization().deserialize(jsonObject);
    }

    public static String[] getAvailableLanguageIds(Document document) {
        return LocalizationUtil.getLocalization().getAvailableLanguageIds(document);
    }

    public static String[] getAvailableLanguageIds(String xml) {
        return LocalizationUtil.getLocalization().getAvailableLanguageIds(xml);
    }

    public static Locale getDefaultImportLocale(String className, long classPK, Locale contentDefaultLocale, Locale[] contentAvailableLocales) {
        return LocalizationUtil.getLocalization().getDefaultImportLocale(className, classPK, contentDefaultLocale, contentAvailableLocales);
    }

    public static Locale getDefaultImportLocale(String className, Serializable primaryKey, Locale contentDefaultLocale, Locale[] contentAvailableLocales) {
        return LocalizationUtil.getLocalization().getDefaultImportLocale(className, primaryKey, contentDefaultLocale, contentAvailableLocales);
    }

    public static String getDefaultLanguageId(Document document) {
        return LocalizationUtil.getLocalization().getDefaultLanguageId(document);
    }

    public static String getDefaultLanguageId(Document document, Locale defaultLocale) {
        return LocalizationUtil.getLocalization().getDefaultLanguageId(document, defaultLocale);
    }

    public static String getDefaultLanguageId(String xml) {
        return LocalizationUtil.getLocalization().getDefaultLanguageId(xml);
    }

    public static String getDefaultLanguageId(String xml, Locale defaultLocale) {
        return LocalizationUtil.getLocalization().getDefaultLanguageId(xml, defaultLocale);
    }

    public static Localization getLocalization() {
        return _localization;
    }

    public static String getLocalization(Function<String, String> localizationFunction, String requestedLanguageId, String defaultLanguageId) {
        return LocalizationUtil.getLocalization().getLocalization(localizationFunction, requestedLanguageId, defaultLanguageId);
    }

    public static String getLocalization(String xml, String requestedLanguageId) {
        return LocalizationUtil.getLocalization().getLocalization(xml, requestedLanguageId);
    }

    public static String getLocalization(String xml, String requestedLanguageId, boolean useDefault) {
        return LocalizationUtil.getLocalization().getLocalization(xml, requestedLanguageId, useDefault);
    }

    public static String getLocalization(String xml, String requestedLanguageId, boolean useDefault, String defaultValue) {
        return LocalizationUtil.getLocalization().getLocalization(xml, requestedLanguageId, useDefault, defaultValue);
    }

    public static Map<Locale, String> getLocalizationMap(Collection<Locale> locales, Locale defaultLocale, String key) {
        return LocalizationUtil.getLocalization().getLocalizationMap(locales, defaultLocale, key);
    }

    public static Map<Locale, String> getLocalizationMap(HttpServletRequest request, String parameter) {
        return LocalizationUtil.getLocalization().getLocalizationMap(request, parameter);
    }

    public static Map<Locale, String> getLocalizationMap(PortletPreferences preferences, String preferenceName) {
        return LocalizationUtil.getLocalization().getLocalizationMap(preferences, preferenceName);
    }

    public static Map<Locale, String> getLocalizationMap(PortletPreferences preferences, String preferenceName, String propertyName) {
        return LocalizationUtil.getLocalization().getLocalizationMap(preferences, preferenceName, propertyName);
    }

    public static Map<Locale, String> getLocalizationMap(PortletPreferences preferences, String preferenceName, String propertyName, String defaultPropertyValue, ClassLoader classLoader) {
        return LocalizationUtil.getLocalization().getLocalizationMap(preferences, preferenceName, propertyName, defaultPropertyValue, classLoader);
    }

    public static Map<Locale, String> getLocalizationMap(PortletRequest portletRequest, String parameter) {
        return LocalizationUtil.getLocalization().getLocalizationMap(portletRequest, parameter);
    }

    public static Map<Locale, String> getLocalizationMap(PortletRequest portletRequest, String parameter, Map<Locale, String> defaultValues) {
        return LocalizationUtil.getLocalization().getLocalizationMap(portletRequest, parameter, defaultValues);
    }

    public static Map<Locale, String> getLocalizationMap(String xml) {
        return LocalizationUtil.getLocalization().getLocalizationMap(xml);
    }

    public static Map<Locale, String> getLocalizationMap(String xml, boolean useDefault) {
        return LocalizationUtil.getLocalization().getLocalizationMap(xml, useDefault);
    }

    public static Map<Locale, String> getLocalizationMap(String bundleName, ClassLoader classLoader, String key, boolean includeBetaLocales) {
        return LocalizationUtil.getLocalization().getLocalizationMap(bundleName, classLoader, key, includeBetaLocales);
    }

    public static Map<Locale, String> getLocalizationMap(String[] languageIds, String[] values) {
        return LocalizationUtil.getLocalization().getLocalizationMap(languageIds, values);
    }

    public static String getLocalizationXmlFromPreferences(PortletPreferences preferences, PortletRequest portletRequest, String parameter) {
        return LocalizationUtil.getLocalization().getLocalizationXmlFromPreferences(preferences, portletRequest, parameter);
    }

    public static String getLocalizationXmlFromPreferences(PortletPreferences preferences, PortletRequest portletRequest, String parameter, String defaultValue) {
        return LocalizationUtil.getLocalization().getLocalizationXmlFromPreferences(preferences, portletRequest, parameter, defaultValue);
    }

    public static String getLocalizationXmlFromPreferences(PortletPreferences preferences, PortletRequest portletRequest, String parameter, String prefix, String defaultValue) {
        return LocalizationUtil.getLocalization().getLocalizationXmlFromPreferences(preferences, portletRequest, parameter, prefix, defaultValue);
    }

    public static String getLocalizedName(String name, String languageId) {
        return LocalizationUtil.getLocalization().getLocalizedName(name, languageId);
    }

    public static Map<Locale, String> getMap(LocalizedValuesMap localizedValuesMap) {
        return LocalizationUtil.getLocalization().getMap(localizedValuesMap);
    }

    public static List<Locale> getModifiedLocales(Map<Locale, String> oldMap, Map<Locale, String> newMap) {
        if (newMap == null || newMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Locale> modifiedLocales = new ArrayList<Locale>();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            String newValue;
            String oldValue = oldMap.get(locale);
            if (oldValue.equals(newValue = newMap.get(locale))) continue;
            modifiedLocales.add(locale);
        }
        return modifiedLocales;
    }

    @Deprecated
    public static String getPreferencesKey(String key, String languageId) {
        return LocalizationUtil.getLocalization().getPreferencesKey(key, languageId);
    }

    public static String getPreferencesValue(PortletPreferences preferences, String key, String languageId) {
        return LocalizationUtil.getLocalization().getPreferencesValue(preferences, key, languageId);
    }

    public static String getPreferencesValue(PortletPreferences preferences, String key, String languageId, boolean useDefault) {
        return LocalizationUtil.getLocalization().getPreferencesValue(preferences, key, languageId, useDefault);
    }

    public static String[] getPreferencesValues(PortletPreferences preferences, String key, String languageId) {
        return LocalizationUtil.getLocalization().getPreferencesValues(preferences, key, languageId);
    }

    public static String[] getPreferencesValues(PortletPreferences preferences, String key, String languageId, boolean useDefault) {
        return LocalizationUtil.getLocalization().getPreferencesValues(preferences, key, languageId, useDefault);
    }

    public static String getSettingsValue(Settings settings, String key, String languageId) {
        return LocalizationUtil.getLocalization().getSettingsValue(settings, key, languageId);
    }

    public static String getSettingsValue(Settings settings, String key, String languageId, boolean useDefault) {
        return LocalizationUtil.getLocalization().getSettingsValue(settings, key, languageId, useDefault);
    }

    public static String[] getSettingsValues(Settings settings, String key, String languageId) {
        return LocalizationUtil.getLocalization().getSettingsValues(settings, key, languageId);
    }

    public static String[] getSettingsValues(Settings settings, String key, String languageId, boolean useDefault) {
        return LocalizationUtil.getLocalization().getSettingsValues(settings, key, languageId, useDefault);
    }

    public static String getXml(LocalizedValuesMap localizedValuesMap, String key) {
        return LocalizationUtil.getLocalization().getXml(localizedValuesMap, key);
    }

    public static String getXml(Map<String, String> map, String defaultLanguageId, String key) {
        return LocalizationUtil.getLocalization().getXml(map, defaultLanguageId, key);
    }

    public static Map<Locale, String> populateLocalizationMap(Map<Locale, String> localizationMap, String defaultLanguageId, long groupId) {
        return LocalizationUtil.getLocalization().populateLocalizationMap(localizationMap, defaultLanguageId, groupId);
    }

    public static String removeLocalization(String xml, String key, String requestedLanguageId) {
        return LocalizationUtil.getLocalization().removeLocalization(xml, key, requestedLanguageId);
    }

    public static String removeLocalization(String xml, String key, String requestedLanguageId, boolean cdata) {
        return LocalizationUtil.getLocalization().removeLocalization(xml, key, requestedLanguageId, cdata);
    }

    public static String removeLocalization(String xml, String key, String requestedLanguageId, boolean cdata, boolean localized) {
        return LocalizationUtil.getLocalization().removeLocalization(xml, key, requestedLanguageId, cdata, localized);
    }

    public static void setLocalizedPreferencesValues(PortletRequest portletRequest, PortletPreferences preferences, String parameter) throws Exception {
        LocalizationUtil.getLocalization().setLocalizedPreferencesValues(portletRequest, preferences, parameter);
    }

    public static void setPreferencesValue(PortletPreferences preferences, String key, String languageId, String value) throws Exception {
        LocalizationUtil.getLocalization().setPreferencesValue(preferences, key, languageId, value);
    }

    public static void setPreferencesValues(PortletPreferences preferences, String key, String languageId, String[] values) throws Exception {
        LocalizationUtil.getLocalization().setPreferencesValues(preferences, key, languageId, values);
    }

    public static String updateLocalization(Map<Locale, String> localizationMap, String xml, String key, String defaultLanguageId) {
        return LocalizationUtil.getLocalization().updateLocalization(localizationMap, xml, key, defaultLanguageId);
    }

    public static String updateLocalization(String xml, String key, String value) {
        return LocalizationUtil.getLocalization().updateLocalization(xml, key, value);
    }

    public static String updateLocalization(String xml, String key, String value, String requestedLanguageId) {
        return LocalizationUtil.getLocalization().updateLocalization(xml, key, value, requestedLanguageId);
    }

    public static String updateLocalization(String xml, String key, String value, String requestedLanguageId, String defaultLanguageId) {
        return LocalizationUtil.getLocalization().updateLocalization(xml, key, value, requestedLanguageId, defaultLanguageId);
    }

    public static String updateLocalization(String xml, String key, String value, String requestedLanguageId, String defaultLanguageId, boolean cdata) {
        return LocalizationUtil.getLocalization().updateLocalization(xml, key, value, requestedLanguageId, defaultLanguageId, cdata);
    }

    public static String updateLocalization(String xml, String key, String value, String requestedLanguageId, String defaultLanguageId, boolean cdata, boolean localized) {
        return LocalizationUtil.getLocalization().updateLocalization(xml, key, value, requestedLanguageId, defaultLanguageId, cdata, localized);
    }

    public void setLocalization(Localization localization) {
        _localization = localization;
    }
}

