/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.document.library.kernel.util.DLAppHelperThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.TemporaryFileEntriesCapability;
import com.liferay.portal.kernel.repository.capabilities.TemporaryFileEntriesScope;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RepositoryLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class TempFileEntryUtil {
    public static final String TEMP_RANDOM_SUFFIX = "--tempRandomSuffix--";
    private static final UUID _UUID = UUID.fromString("00EF1134-B3EE-432A-BABD-367CEFA44DE1");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FileEntry addTempFileEntry(long groupId, long userId, String folderName, String fileName, File file, String mimeType) throws PortalException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            FileEntry fileEntry = TempFileEntryUtil.addTempFileEntry(groupId, userId, folderName, fileName, inputStream, mimeType);
            return fileEntry;
        }
        catch (IOException ioe) {
            throw new PortalException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileEntry addTempFileEntry(long groupId, long userId, String folderName, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled(false);
            TemporaryFileEntriesCapability temporaryFileEntriesCapability = TempFileEntryUtil._getTemporaryFileEntriesCapability(groupId);
            FileEntry fileEntry = temporaryFileEntriesCapability.addTemporaryFileEntry(new TemporaryFileEntriesScope(_UUID, userId, folderName), fileName, mimeType, inputStream);
            return fileEntry;
        }
        finally {
            DLAppHelperThreadLocal.setEnabled(dlAppHelperEnabled);
        }
    }

    public static void deleteTempFileEntry(long fileEntryId) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getFileEntryLocalRepository(fileEntryId);
        FileEntry fileEntry = localRepository.getFileEntry(fileEntryId);
        Folder folder = fileEntry.getFolder();
        TempFileEntryUtil.deleteTempFileEntry(fileEntry.getGroupId(), fileEntry.getUserId(), folder.getName(), fileEntry.getTitle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTempFileEntry(long groupId, long userId, String folderName, String fileName) throws PortalException {
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled(false);
            TemporaryFileEntriesCapability temporaryFileEntriesCapability = TempFileEntryUtil._getTemporaryFileEntriesCapability(groupId);
            temporaryFileEntriesCapability.deleteTemporaryFileEntry(new TemporaryFileEntriesScope(_UUID, userId, folderName), fileName);
        }
        finally {
            DLAppHelperThreadLocal.setEnabled(dlAppHelperEnabled);
        }
    }

    public static String getOriginalTempFileName(String tempFileName) {
        String extension = FileUtil.getExtension(tempFileName);
        int pos = tempFileName.lastIndexOf(TEMP_RANDOM_SUFFIX);
        if (pos != -1) {
            tempFileName = tempFileName.substring(0, pos);
            if (Validator.isNotNull(extension)) {
                tempFileName = tempFileName + "." + extension;
            }
        }
        return tempFileName;
    }

    public static FileEntry getTempFileEntry(long groupId, long userId, String folderName, String fileName) throws PortalException {
        TemporaryFileEntriesCapability temporaryFileEntriesCapability = TempFileEntryUtil._getTemporaryFileEntriesCapability(groupId);
        return temporaryFileEntriesCapability.getTemporaryFileEntry(new TemporaryFileEntriesScope(_UUID, userId, folderName), fileName);
    }

    public static String getTempFileName(String originalFileName) {
        StringBundler sb = new StringBundler(5);
        sb.append(FileUtil.stripExtension(originalFileName));
        sb.append(TEMP_RANDOM_SUFFIX);
        sb.append(StringUtil.randomString());
        String extension = FileUtil.getExtension(originalFileName);
        if (Validator.isNotNull(extension)) {
            sb.append(".");
            sb.append(extension);
        }
        return sb.toString();
    }

    public static String[] getTempFileNames(long groupId, long userId, String folderName) throws PortalException {
        TemporaryFileEntriesCapability temporaryFileEntriesCapability = TempFileEntryUtil._getTemporaryFileEntriesCapability(groupId);
        List<FileEntry> fileEntries = temporaryFileEntriesCapability.getTemporaryFileEntries(new TemporaryFileEntriesScope(_UUID, userId, folderName));
        ArrayList<String> fileNames = new ArrayList<String>();
        for (FileEntry fileEntry : fileEntries) {
            fileNames.add(fileEntry.getFileName());
        }
        return ArrayUtil.toStringArray(fileNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LocalRepository _addPortletRepository(long groupId, ServiceContext serviceContext) throws PortalException {
        Repository repository = RepositoryLocalServiceUtil.fetchRepository(groupId, TempFileEntryUtil.class.getName(), "");
        if (repository != null) {
            return RepositoryProviderUtil.getLocalRepository(repository.getRepositoryId());
        }
        Group group = GroupLocalServiceUtil.getGroup(groupId);
        User user = UserLocalServiceUtil.getDefaultUser(group.getCompanyId());
        long classNameId = PortalUtil.getClassNameId("com.liferay.portal.repository.temporaryrepository.TemporaryFileEntryRepository");
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled(false);
            repository = RepositoryLocalServiceUtil.addRepository(user.getUserId(), groupId, classNameId, 0L, TempFileEntryUtil.class.getName(), "", "", typeSettingsProperties, true, serviceContext);
            LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(repository.getRepositoryId());
            return localRepository;
        }
        finally {
            DLAppHelperThreadLocal.setEnabled(dlAppHelperEnabled);
        }
    }

    private static TemporaryFileEntriesCapability _getTemporaryFileEntriesCapability(long groupId) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        LocalRepository localRepository = TempFileEntryUtil._addPortletRepository(groupId, serviceContext);
        return localRepository.getCapability(TemporaryFileEntriesCapability.class);
    }
}

